/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.models;

import com.majruszs_difficulty.entities.TankEntity;
import com.mlib.animations.Animation;
import com.mlib.animations.Frame;
import com.mlib.animations.FrameDegrees;
import com.mlib.animations.FrameVec3;
import com.mlib.math.VectorHelper;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TankModel<Type extends TankEntity>
extends HierarchicalModel<Type> {
    protected static final Animation<Float> SPECIAL_ATTACK_BODY_X = new Animation();
    protected static final Animation<Float> SPECIAL_ATTACK_ARMS_X;
    protected static final Animation<Float> NORMAL_ATTACK_BODY_Y;
    protected static final Animation<Vec3> NORMAL_ATTACK_ARM;
    public ModelPart root;
    public ModelPart body;
    public ModelPart head;
    public ModelPart arms;
    public ModelPart leftArm;
    public ModelPart leftForearm;
    public ModelPart rightArm;
    public ModelPart rightForearm;
    public ModelPart leftLeg;
    public ModelPart rightLeg;
    protected float normalAttackDurationRatioLeft = 0.0f;
    protected float specialAttackDurationRatioLeft = 0.0f;
    protected boolean isLeftHandAttack = false;

    public TankModel(ModelPart modelPart) {
        this.root = modelPart;
        this.body = this.root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.arms = this.body.m_171324_("arms");
        this.leftArm = this.arms.m_171324_("leftArm");
        this.leftForearm = this.leftArm.m_171324_("leftForearm");
        this.rightArm = this.arms.m_171324_("rightArm");
        this.rightForearm = this.rightArm.m_171324_("rightForearm");
        this.leftLeg = this.root.m_171324_("leftLeg");
        this.rightLeg = this.root.m_171324_("rightLeg");
    }

    public void setupAnim(Type entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float handMultiplier = this.isLeftHandAttack ? -1.0f : 1.0f;
        float limbFactor1 = limbSwing * 0.3333f;
        float limbFactor2 = 0.9f * limbSwingAmount;
        float bodyFactor = 0.2f * limbSwingAmount;
        Vec3 vectorHandMultiplier = new Vec3(1.0, (double)handMultiplier, (double)handMultiplier);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180) + 0.0873f;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)limbFactor1) * limbFactor2;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbFactor1 + (float)Math.PI)) * limbFactor2;
        this.body.f_104205_ = Mth.m_14089_((float)limbFactor1) * bodyFactor;
        this.body.f_104204_ = this.head.f_104204_ * 0.4f + handMultiplier * ((Float)NORMAL_ATTACK_BODY_Y.apply(this.normalAttackDurationRatioLeft)).floatValue();
        Vec3 armRotation = VectorHelper.multiply((Vec3)((Vec3)NORMAL_ATTACK_ARM.apply(this.normalAttackDurationRatioLeft)), (Vec3)vectorHandMultiplier);
        Animation.applyRotationInDegrees((Vec3)armRotation, (ModelPart)(this.isLeftHandAttack ? this.leftArm : this.rightArm));
        this.body.f_104203_ = ((Float)SPECIAL_ATTACK_BODY_X.apply(this.specialAttackDurationRatioLeft)).floatValue();
        this.arms.f_104203_ = ((Float)SPECIAL_ATTACK_ARMS_X.apply(this.specialAttackDurationRatioLeft)).floatValue();
    }

    public void prepareMobModel(Type tank, float p_102862_, float p_102863_, float packedLight) {
        this.normalAttackDurationRatioLeft = ((TankEntity)((Object)tank)).isAttacking(TankEntity.AttackType.NORMAL) ? ((TankEntity)((Object)tank)).getAttackDurationRatioLeft() : 1.0f;
        this.specialAttackDurationRatioLeft = ((TankEntity)((Object)tank)).isAttacking(TankEntity.AttackType.SPECIAL) ? ((TankEntity)((Object)tank)).getAttackDurationRatioLeft() : 1.0f;
        this.isLeftHandAttack = ((TankEntity)((Object)tank)).isLeftHandAttack;
        super.m_6839_(tank, p_102862_, p_102863_, packedLight);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-8.0f, -22.0f, -5.0f, 16.0f, 12.0f, 8.0f, cubeDeformation).m_171514_(36, 40).m_171488_(-1.0f, -23.0f, 1.0f, 2.0f, 22.0f, 2.0f, cubeDeformation.m_171469_(-0.1f)).m_171514_(0, 40).m_171488_(-6.0f, -4.0f, -3.0f, 12.0f, 4.0f, 6.0f, cubeDeformation), PartPose.m_171423_((float)0.0f, (float)12.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        partDefinition.m_171597_("body").m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -10.0f, -5.0f, 10.0f, 10.0f, 10.0f, cubeDeformation), PartPose.m_171423_((float)0.0f, (float)-22.0f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        partDefinition.m_171597_("body").m_171599_("arms", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-22.0f, (float)0.0f));
        partDefinition.m_171597_("body").m_171597_("arms").m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 16.0f, 5.0f, cubeDeformation), PartPose.m_171423_((float)-9.5f, (float)0.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.1745f));
        partDefinition.m_171597_("body").m_171597_("arms").m_171597_("rightArm").m_171599_("rightForearm", CubeListBuilder.m_171558_().m_171514_(44, 37).m_171488_(-2.5f, -0.5f, -2.5f, 5.0f, 16.0f, 5.0f, cubeDeformation.m_171469_(-0.2f)), PartPose.m_171423_((float)0.0f, (float)14.5f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        partDefinition.m_171597_("body").m_171597_("arms").m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 16.0f, 5.0f, cubeDeformation), PartPose.m_171423_((float)9.5f, (float)0.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        partDefinition.m_171597_("body").m_171597_("arms").m_171597_("leftArm").m_171599_("leftForearm", CubeListBuilder.m_171558_().m_171514_(44, 37).m_171488_(-2.5f, -2.0f, -3.5f, 5.0f, 16.0f, 5.0f, cubeDeformation.m_171469_(-0.2f)), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        partDefinition.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)3.0f, (float)12.0f, (float)0.0f));
        partDefinition.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)-3.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    static {
        SPECIAL_ATTACK_BODY_X.addFrame((Frame)new FrameDegrees(0.0f, 10.0f)).addFrame((Frame)new FrameDegrees(0.3f, -30.0f, Frame.InterpolationType.SQUARE)).addFrame((Frame)new FrameDegrees(0.4f, -30.0f)).addFrame((Frame)new FrameDegrees(0.6f, 45.0f, Frame.InterpolationType.SQUARE)).addFrame((Frame)new FrameDegrees(0.7f, 35.0f)).addFrame((Frame)new FrameDegrees(0.85f, 0.0f, Frame.InterpolationType.SQUARE)).addFrame((Frame)new FrameDegrees(1.0f, 10.0f));
        SPECIAL_ATTACK_ARMS_X = new Animation();
        SPECIAL_ATTACK_ARMS_X.addFrame((Frame)new FrameDegrees(0.0f, 0.0f)).addFrame((Frame)new FrameDegrees(0.4f, -160.0f, Frame.InterpolationType.SQUARE)).addFrame((Frame)new FrameDegrees(0.6f, -40.0f, Frame.InterpolationType.SQUARE)).addFrame((Frame)new FrameDegrees(0.7f, -30.0f)).addFrame((Frame)new FrameDegrees(0.85f, 10.0f, Frame.InterpolationType.SQUARE)).addFrame((Frame)new FrameDegrees(1.0f, 0.0f, Frame.InterpolationType.SQUARE));
        NORMAL_ATTACK_BODY_Y = new Animation();
        NORMAL_ATTACK_BODY_Y.addFrame((Frame)new FrameDegrees(0.0f, 0.0f)).addFrame((Frame)new FrameDegrees(0.15f, 30.0f, Frame.InterpolationType.SQUARE)).addFrame((Frame)new FrameDegrees(0.25f, 30.0f)).addFrame((Frame)new FrameDegrees(0.45f, -60.0f, Frame.InterpolationType.SQUARE)).addFrame((Frame)new FrameDegrees(0.55f, -50.0f)).addFrame((Frame)new FrameDegrees(1.0f, 0.0f, Frame.InterpolationType.SQUARE));
        NORMAL_ATTACK_ARM = new Animation();
        NORMAL_ATTACK_ARM.addFrame((Frame)new FrameVec3(0.0f, 0.0, 0.0, 10.0)).addFrame((Frame)new FrameVec3(0.2f, 45.0, 0.0, 45.0, Frame.InterpolationType.SQUARE)).addFrame((Frame)new FrameVec3(0.3f, 45.0, 0.0, 45.0)).addFrame((Frame)new FrameVec3(0.5f, -90.0, -30.0, 60.0, Frame.InterpolationType.SQUARE)).addFrame((Frame)new FrameVec3(0.6f, -80.0, -25.0, 50.0, Frame.InterpolationType.SQUARE)).addFrame((Frame)new FrameVec3(1.0f, 0.0, 0.0, 10.0, Frame.InterpolationType.SQUARE));
    }
}

