/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.mannequins.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.BiConsumer;
import java.util.function.Function;
import me.jaackson.mannequins.bridge.NetworkBridge;
import me.jaackson.mannequins.client.screen.component.ScrollBar;
import me.jaackson.mannequins.client.util.ScissorHelper;
import me.jaackson.mannequins.common.entity.Mannequin;
import me.jaackson.mannequins.common.menu.MannequinInventoryMenu;
import me.jaackson.mannequins.common.network.ServerboundSetMannequinPose;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2379;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_4893;
import net.minecraft.class_490;

public class MannequinScreen
extends class_465<MannequinInventoryMenu> {
    public static final class_2960 TEXTURE = new class_2960("mannequins", "textures/gui/container/mannequin.png");
    private static MannequinPart selectedPart = MannequinPart.HEAD;
    private final Mannequin mannequin;
    private ScrollBar xScroll;
    private ScrollBar yScroll;
    private ScrollBar zScroll;

    public MannequinScreen(MannequinInventoryMenu menu, class_1661 inventory, Mannequin mannequin) {
        super((class_1703)menu, inventory, mannequin.method_5476());
        this.mannequin = mannequin;
        this.field_22792 = false;
        this.field_2779 = 185;
        this.field_25270 += 20;
    }

    protected void method_25426() {
        super.method_25426();
        this.xScroll = new ScrollBar(this.field_2776 + 136, this.field_2800 + 20, 8, 65, 360, (class_2561)new class_2585("X"));
        this.method_25411(this.xScroll);
        this.yScroll = new ScrollBar(this.field_2776 + 147, this.field_2800 + 20, 8, 65, 360, (class_2561)new class_2585("Y"));
        this.method_25411(this.yScroll);
        this.zScroll = new ScrollBar(this.field_2776 + 158, this.field_2800 + 20, 8, 65, 360, (class_2561)new class_2585("Z"));
        this.method_25411(this.zScroll);
        this.xScroll.setScrollSpeed(1.0f);
        this.yScroll.setScrollSpeed(1.0f);
        this.zScroll.setScrollSpeed(1.0f);
        this.updateSliders();
    }

    private void updateSliders() {
        class_2379 rotations = selectedPart.getRotation(this.mannequin);
        float rotationX = class_3532.method_15393((float)rotations.method_10256()) + 180.0f;
        float rotationY = class_3532.method_15393((float)rotations.method_10257()) + 180.0f;
        float rotationZ = class_3532.method_15393((float)rotations.method_10258()) + 180.0f;
        if (selectedPart == MannequinPart.LEFT_ARM) {
            rotationZ = 360.0f - rotationZ;
        }
        this.xScroll.setScroll(rotationX % 360.0f / 360.0f * (float)this.xScroll.getMaxScroll());
        this.yScroll.setScroll(rotationY % 360.0f / 360.0f * (float)this.yScroll.getMaxScroll());
        this.zScroll.setScroll(rotationZ % 360.0f / 360.0f * (float)this.zScroll.getMaxScroll());
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (MannequinPart part : MannequinPart.values()) {
            if (selectedPart == part || !part.isHovered(mouseX - (double)this.field_2776, mouseY - (double)this.field_2800)) continue;
            selectedPart = part;
            this.updateSliders();
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseButton) {
        return this.xScroll.method_25406(mouseX, mouseY, mouseButton) || this.yScroll.method_25406(mouseX, mouseY, mouseButton) || this.zScroll.method_25406(mouseX, mouseY, mouseButton) || super.method_25406(mouseX, mouseY, mouseButton);
    }

    public void method_25393() {
        super.method_25393();
        for (class_339 widget : this.field_22791) {
            if (!(widget instanceof class_4893)) continue;
            ((class_4893)widget).method_25393();
        }
    }

    protected void method_2389(class_4587 poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_22787.method_1531().method_22813(TEXTURE);
        this.method_25302(poseStack, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        for (MannequinPart part : MannequinPart.values()) {
            if (selectedPart == part) continue;
            this.method_25302(poseStack, this.field_2776 + part.xOffset, this.field_2800 + part.yOffset, part.isHovered(mouseX - this.field_2776, mouseY - this.field_2800) ? part.buttonU + part.buttonWidth : part.buttonU, part.buttonV, part.buttonWidth, part.buttonHeight);
        }
        ScissorHelper.push(this.field_2776 + 26, this.field_2800 + 18, 49.0f, 70.0f);
        class_490.method_2486((int)(this.field_2776 + 51), (int)(this.field_2800 + 80), (int)28, (float)0.0f, (float)-30.0f, (class_1309)this.mannequin);
        ScissorHelper.pop();
    }

    public void method_25394(class_4587 arg, int mouseX, int mouseY, float partialTicks) {
        partialTicks = class_310.method_1551().method_1488();
        this.method_25420(arg);
        super.method_25394(arg, mouseX, mouseY, partialTicks);
        this.method_2380(arg, mouseX, mouseY);
        class_2379 rotations = selectedPart.getRotation(this.mannequin);
        float x = this.xScroll.getInterpolatedScrollPercentage(partialTicks) * 360.0f - 180.0f;
        float y = this.yScroll.getInterpolatedScrollPercentage(partialTicks) * 360.0f - 180.0f;
        float z = this.zScroll.getInterpolatedScrollPercentage(partialTicks) * 360.0f - 180.0f;
        if (selectedPart == MannequinPart.LEFT_ARM) {
            z *= -1.0f;
        }
        if (rotations.method_10256() != x || rotations.method_10257() != y || rotations.method_10258() != z) {
            selectedPart.setRotation(this.mannequin, new class_2379(x, y, z));
        }
    }

    public void method_25419() {
        NetworkBridge.sendServerbound(ServerboundSetMannequinPose.CHANNEL, new ServerboundSetMannequinPose(((MannequinInventoryMenu)this.field_2797).field_7763, this.mannequin.getHeadPose(), this.mannequin.getBodyPose(), this.mannequin.getLeftArmPose(), this.mannequin.getRightArmPose()));
        super.method_25419();
    }

    static enum MannequinPart {
        HEAD(Mannequin::setHeadPose, Mannequin::getHeadPose, 98, 21, 176, 59, 16, 16),
        CHEST(Mannequin::setBodyPose, Mannequin::getBodyPose, 98, 37, 176, 39, 16, 20),
        LEFT_ARM(Mannequin::setLeftArmPose, Mannequin::getLeftArmPose, 114, 37, 176, 15, 8, 24),
        RIGHT_ARM(Mannequin::setRightArmPose, Mannequin::getRightArmPose, 90, 37, 176, 15, 8, 24);

        private final BiConsumer<Mannequin, class_2379> rotationSetter;
        private final Function<Mannequin, class_2379> rotationGetter;
        private final int xOffset;
        private final int yOffset;
        private final int buttonU;
        private final int buttonV;
        private final int buttonWidth;
        private final int buttonHeight;

        private MannequinPart(BiConsumer<Mannequin, class_2379> rotationSetter, Function<Mannequin, class_2379> rotationGetter, int xOffset, int yOffset, int buttonU, int buttonV, int buttonWidth, int buttonHeight) {
            this.rotationSetter = rotationSetter;
            this.rotationGetter = rotationGetter;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.buttonU = buttonU;
            this.buttonV = buttonV;
            this.buttonWidth = buttonWidth;
            this.buttonHeight = buttonHeight;
        }

        public boolean isHovered(double mouseX, double mouseY) {
            return mouseX >= (double)this.xOffset && mouseX < (double)(this.xOffset + this.buttonWidth) && mouseY >= (double)this.yOffset && mouseY < (double)(this.yOffset + this.buttonHeight);
        }

        public class_2379 getRotation(Mannequin mannequin) {
            return this.rotationGetter.apply(mannequin);
        }

        public void setRotation(Mannequin mannequin, class_2379 rot) {
            this.rotationSetter.accept(mannequin, rot);
        }
    }
}

