/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.mannequins.common.entity;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import me.jaackson.mannequins.Mannequins;
import me.jaackson.mannequins.bridge.EventBridge;
import me.jaackson.mannequins.bridge.NetworkBridge;
import me.jaackson.mannequins.bridge.PlayerBridge;
import me.jaackson.mannequins.common.menu.MannequinInventoryMenu;
import me.jaackson.mannequins.common.network.ClientboundAttackMannequin;
import me.jaackson.mannequins.common.network.ClientboundOpenMannequinScreen;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1712;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2379;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.jetbrains.annotations.Nullable;

public class Mannequin
extends class_1309 {
    public static final class_2940<class_2379> DATA_HEAD_POSE = class_2945.method_12791(Mannequin.class, (class_2941)class_2943.field_13316);
    public static final class_2940<class_2379> DATA_BODY_POSE = class_2945.method_12791(Mannequin.class, (class_2941)class_2943.field_13316);
    public static final class_2940<class_2379> DATA_LEFT_ARM_POSE = class_2945.method_12791(Mannequin.class, (class_2941)class_2943.field_13316);
    public static final class_2940<class_2379> DATA_RIGHT_ARM_POSE = class_2945.method_12791(Mannequin.class, (class_2941)class_2943.field_13316);
    public static final class_2940<Boolean> DATA_DISABLED = class_2945.method_12791(Mannequin.class, (class_2941)class_2943.field_13323);
    private static final Predicate<class_1297> MINECART = entity -> entity instanceof class_1688 && ((class_1688)entity).method_7518() == class_1688.class_1689.field_7674;
    private static final class_2379 DEFAULT_HEAD_POSE = new class_2379(0.0f, 0.0f, 0.0f);
    private static final class_2379 DEFAULT_BODY_POSE = new class_2379(0.0f, 0.0f, 0.0f);
    private static final class_2379 DEFAULT_LEFT_ARM_POSE = new class_2379(-10.0f, 0.0f, -10.0f);
    private static final class_2379 DEFAULT_RIGHT_ARM_POSE = new class_2379(-10.0f, 0.0f, 10.0f);
    private final class_1277 inventory = new class_1277(4);
    public long lastHit;
    private class_2379 headPose = DEFAULT_HEAD_POSE;
    private class_2379 bodyPose = DEFAULT_BODY_POSE;
    private class_2379 leftArmPose = DEFAULT_LEFT_ARM_POSE;
    private class_2379 rightArmPose = DEFAULT_RIGHT_ARM_POSE;
    private int attackAnimation;
    private float attackAnimationXFactor;
    private float attackAnimationZFactor;

    public Mannequin(class_1299<? extends Mannequin> type, class_1937 level) {
        super(type, level);
        this.field_6013 = 0.0f;
    }

    public void onAttack(float attackYaw) {
        float rotation = attackYaw - (float)((double)this.field_6283 / 180.0 * Math.PI);
        this.field_6271 = attackYaw;
        this.attackAnimation = 40;
        this.attackAnimationXFactor = class_3532.method_15362((float)rotation);
        this.attackAnimationZFactor = class_3532.method_15374((float)rotation);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_HEAD_POSE, (Object)DEFAULT_HEAD_POSE);
        this.field_6011.method_12784(DATA_BODY_POSE, (Object)DEFAULT_BODY_POSE);
        this.field_6011.method_12784(DATA_LEFT_ARM_POSE, (Object)DEFAULT_LEFT_ARM_POSE);
        this.field_6011.method_12784(DATA_RIGHT_ARM_POSE, (Object)DEFAULT_RIGHT_ARM_POSE);
        this.field_6011.method_12784(DATA_DISABLED, (Object)false);
    }

    public Iterable<class_1799> method_5877() {
        return Collections.emptyList();
    }

    public Iterable<class_1799> method_5661() {
        return Collections.emptyList();
    }

    public class_1799 method_6118(class_1304 slot) {
        if (slot == null) {
            return class_1799.field_8037;
        }
        switch (slot) {
            case field_6169: {
                return this.inventory.method_5438(0);
            }
            case field_6174: {
                return this.inventory.method_5438(1);
            }
            case field_6173: {
                return this.inventory.method_5438(2);
            }
            case field_6171: {
                return this.inventory.method_5438(3);
            }
        }
        return class_1799.field_8037;
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
        if (slot == null) {
            return;
        }
        switch (slot) {
            case field_6169: {
                this.inventory.method_5447(0, stack);
                break;
            }
            case field_6174: {
                this.inventory.method_5447(1, stack);
                break;
            }
            case field_6173: {
                this.inventory.method_5447(2, stack);
                break;
            }
            case field_6171: {
                this.inventory.method_5447(3, stack);
            }
        }
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10566("Pose", (class_2520)this.writePose());
        tag.method_10556("Disabled", this.isDisabled());
        class_2499 listTag = new class_2499();
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 itemStack = this.inventory.method_5438(i);
            if (itemStack.method_7960()) continue;
            class_2487 compoundTag2 = new class_2487();
            compoundTag2.method_10567("Slot", (byte)i);
            itemStack.method_7953(compoundTag2);
            listTag.add((Object)compoundTag2);
        }
        tag.method_10566("Items", (class_2520)listTag);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.readPose(tag.method_10562("Pose"));
        this.field_6011.method_12778(DATA_DISABLED, (Object)tag.method_10577("Disabled"));
        class_2499 listTag = tag.method_10554("Items", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            class_2487 compoundTag2 = listTag.method_10602(i);
            int j = compoundTag2.method_10571("Slot") & 0xFF;
            if (j >= this.inventory.method_5439()) continue;
            this.inventory.method_5447(j, class_1799.method_7915((class_2487)compoundTag2));
        }
    }

    private void readPose(class_2487 tag) {
        class_2499 headPose = tag.method_10554("Head", 5);
        this.setHeadPose(headPose.isEmpty() ? DEFAULT_HEAD_POSE : new class_2379(headPose));
        class_2499 bodyPose = tag.method_10554("Body", 5);
        this.setBodyPose(bodyPose.isEmpty() ? DEFAULT_BODY_POSE : new class_2379(bodyPose));
        class_2499 leftArmPose = tag.method_10554("LeftArm", 5);
        this.setLeftArmPose(leftArmPose.isEmpty() ? DEFAULT_LEFT_ARM_POSE : new class_2379(leftArmPose));
        class_2499 rightArmPose = tag.method_10554("RightArm", 5);
        this.setRightArmPose(rightArmPose.isEmpty() ? DEFAULT_RIGHT_ARM_POSE : new class_2379(rightArmPose));
    }

    private class_2487 writePose() {
        class_2487 pose = new class_2487();
        if (!DEFAULT_HEAD_POSE.equals((Object)this.headPose)) {
            pose.method_10566("Head", (class_2520)this.headPose.method_10255());
        }
        if (!DEFAULT_BODY_POSE.equals((Object)this.bodyPose)) {
            pose.method_10566("Body", (class_2520)this.bodyPose.method_10255());
        }
        if (!DEFAULT_LEFT_ARM_POSE.equals((Object)this.leftArmPose)) {
            pose.method_10566("LeftArm", (class_2520)this.leftArmPose.method_10255());
        }
        if (!DEFAULT_RIGHT_ARM_POSE.equals((Object)this.rightArmPose)) {
            pose.method_10566("RightArm", (class_2520)this.rightArmPose.method_10255());
        }
        return pose;
    }

    public boolean method_5810() {
        return false;
    }

    protected void method_6087(class_1297 entity) {
    }

    protected void method_6070() {
        List list = this.field_6002.method_8333((class_1297)this, this.method_5829(), MINECART);
        for (class_1297 entity : list) {
            if (!(this.method_5858(entity) <= 0.2)) continue;
            entity.method_5697((class_1297)this);
        }
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (this.isDisabled()) {
            return class_1269.field_5814;
        }
        if (!player.method_5998(hand).method_7960() && !player.method_21823()) {
            return class_1269.field_5811;
        }
        if (this.field_6002.method_8608()) {
            return class_1269.field_5812;
        }
        class_3222 serverPlayer = (class_3222)player;
        if (serverPlayer.field_7512 != serverPlayer.field_7498) {
            serverPlayer.method_7346();
        }
        PlayerBridge.incrementContainerId(serverPlayer);
        NetworkBridge.sendClientbound(ClientboundOpenMannequinScreen.CHANNEL, serverPlayer, new ClientboundOpenMannequinScreen(PlayerBridge.getContainerId(serverPlayer), this.method_5628()));
        serverPlayer.field_7512 = new MannequinInventoryMenu(PlayerBridge.getContainerId(serverPlayer), serverPlayer.field_7514, (class_1263)this.inventory, this);
        serverPlayer.field_7512.method_7596((class_1712)serverPlayer);
        EventBridge.fireContainerOpenEvent(serverPlayer, serverPlayer.field_7512);
        return class_1269.field_21466;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.field_6002.method_8608() || !this.method_5805()) {
            return false;
        }
        if (class_1282.field_5849.equals(source)) {
            this.method_5650();
            return false;
        }
        if (this.method_5679(source)) {
            return false;
        }
        if (source.method_5535()) {
            this.brokenByAnything(source);
            this.method_5650();
            return false;
        }
        if (class_1282.field_5867.equals(source)) {
            if (this.method_5809()) {
                this.causeDamage(source, 0.15f);
            } else {
                this.method_5639(5);
            }
            return false;
        }
        if (class_1282.field_5854.equals(source) && this.method_6032() > 0.5f) {
            this.causeDamage(source, 4.0f);
            return false;
        }
        class_1297 entity = source.method_5529();
        if (entity == null || !(source.method_5526() instanceof class_1657) || !entity.method_5715()) {
            class_243 pos = source.method_5510();
            if (pos == null) {
                return false;
            }
            this.field_6271 = (float)(-class_3532.method_15349((double)(pos.method_10216() - this.method_23317()), (double)(pos.method_10215() - this.method_23321())));
            this.field_6002.method_8421((class_1297)this, (byte)32);
            NetworkBridge.sendClientboundTracking(ClientboundAttackMannequin.CHANNEL, (class_1297)this, new ClientboundAttackMannequin(this.method_5628(), this.field_6271));
            if (amount > 0.0f) {
                ((class_3218)this.field_6002).method_14199((class_2394)class_2398.field_11209, this.method_23317(), this.method_23320(), this.method_23321(), (int)((double)amount * 0.5), 0.1, 0.0, 0.1, 0.2);
            }
            return false;
        }
        if (source.method_5529() instanceof class_1657 && !((class_1657)source.method_5529()).field_7503.field_7476) {
            return false;
        }
        if (source.method_5530()) {
            this.playBrokenSound();
            this.showBreakingParticles();
            this.method_5650();
            return true;
        }
        long time = this.field_6002.method_8510();
        if (time - this.lastHit > 5L) {
            this.field_6002.method_8421((class_1297)this, (byte)32);
            this.lastHit = time;
        } else {
            this.brokenByPlayer(source);
            this.showBreakingParticles();
            this.method_5650();
        }
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5711(byte event) {
        if (event == 32) {
            if (this.field_6002.field_9236) {
                this.field_6002.method_8486(this.method_23317(), this.method_23318(), this.method_23321(), Mannequins.mannequinHitSound.get(), this.method_5634(), 0.3f, 1.0f, false);
                this.lastHit = this.field_6002.method_8510();
            }
        } else {
            super.method_5711(event);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_5640(double distance) {
        double d0 = this.method_5829().method_995() * 4.0;
        if (Double.isNaN(d0) || d0 == 0.0) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    private void showBreakingParticles() {
        if (this.field_6002 instanceof class_3218) {
            ((class_3218)this.field_6002).method_14199((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10161.method_9564()), this.method_23317(), this.method_23323(0.6666666666666666), this.method_23321(), 10, (double)(this.method_17681() / 4.0f), (double)(this.method_17682() / 4.0f), (double)(this.method_17681() / 4.0f), 0.05);
        }
    }

    private void causeDamage(class_1282 source, float damage) {
        float f = this.method_6032();
        if ((f -= damage) <= 0.5f) {
            this.brokenByAnything(source);
            this.method_5650();
        } else {
            this.method_6033(f);
        }
    }

    private void brokenByPlayer(class_1282 source) {
        class_2248.method_9577((class_1937)this.field_6002, (class_2338)this.method_24515(), (class_1799)new class_1799((class_1935)Mannequins.mannequinItem.get()));
        this.brokenByAnything(source);
    }

    private void brokenByAnything(class_1282 source) {
        this.playBrokenSound();
        this.method_16080(source);
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 stack = this.inventory.method_5438(i);
            if (stack.method_7960()) continue;
            class_2248.method_9577((class_1937)this.field_6002, (class_2338)this.method_24515().method_10084(), (class_1799)stack);
            this.inventory.method_5447(i, class_1799.field_8037);
        }
    }

    private void playBrokenSound() {
        this.field_6002.method_8465(null, this.method_23317(), this.method_23318(), this.method_23321(), Mannequins.mannequinBreakSound.get(), this.method_5634(), 1.0f, 1.0f);
    }

    protected float method_6031(float p_110146_1_, float p_110146_2_) {
        this.field_6220 = this.field_5982;
        this.field_6283 = this.field_6031;
        return 0.0f;
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068 * 0.86f;
    }

    public double method_5678() {
        return 0.1f;
    }

    public void method_5636(float rot) {
        this.field_6220 = this.field_5982 = rot;
        this.field_6259 = this.field_6241 = rot;
    }

    public void method_5847(float rot) {
        this.field_6220 = this.field_5982 = rot;
        this.field_6259 = this.field_6241 = rot;
    }

    public void method_5773() {
        class_2379 rightArmPose;
        class_2379 leftArmPose;
        class_2379 bodyPose;
        super.method_5773();
        class_2379 headPose = (class_2379)this.field_6011.method_12789(DATA_HEAD_POSE);
        if (!this.headPose.equals((Object)headPose)) {
            this.setHeadPose(headPose);
        }
        if (!this.bodyPose.equals((Object)(bodyPose = (class_2379)this.field_6011.method_12789(DATA_BODY_POSE)))) {
            this.setBodyPose(bodyPose);
        }
        if (!this.leftArmPose.equals((Object)(leftArmPose = (class_2379)this.field_6011.method_12789(DATA_LEFT_ARM_POSE)))) {
            this.setLeftArmPose(leftArmPose);
        }
        if (!this.rightArmPose.equals((Object)(rightArmPose = (class_2379)this.field_6011.method_12789(DATA_RIGHT_ARM_POSE)))) {
            this.setRightArmPose(rightArmPose);
        }
        if (this.field_6002.method_8608()) {
            if (this.attackAnimation <= 0) {
                return;
            }
            --this.attackAnimation;
        }
    }

    public void method_5768() {
        this.method_5650();
    }

    private float getAttackAnimation(float partialTicks) {
        float x = (float)this.attackAnimation - partialTicks;
        return class_3532.method_15362((float)x) / 2.0f * class_3532.method_15355((float)x) / (50.0f - x);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean hasAnimation() {
        return this.attackAnimation > 0;
    }

    @Environment(value=EnvType.CLIENT)
    public float getAnimationRotationX(float partialTicks) {
        return this.attackAnimationXFactor * this.getAttackAnimation(partialTicks);
    }

    @Environment(value=EnvType.CLIENT)
    public float getAnimationRotationZ(float partialTicks) {
        return this.attackAnimationZFactor * this.getAttackAnimation(partialTicks);
    }

    public boolean isDisabled() {
        return (Boolean)this.field_6011.method_12789(DATA_DISABLED);
    }

    public class_2379 getHeadPose() {
        return this.headPose;
    }

    public void setHeadPose(class_2379 pose) {
        this.headPose = pose;
        this.field_6011.method_12778(DATA_HEAD_POSE, (Object)pose);
    }

    public class_2379 getBodyPose() {
        return this.bodyPose;
    }

    public void setBodyPose(class_2379 pose) {
        this.bodyPose = pose;
        this.field_6011.method_12778(DATA_BODY_POSE, (Object)pose);
    }

    public class_2379 getLeftArmPose() {
        return this.leftArmPose;
    }

    public void setLeftArmPose(class_2379 pose) {
        this.leftArmPose = pose;
        this.field_6011.method_12778(DATA_LEFT_ARM_POSE, (Object)pose);
    }

    public class_2379 getRightArmPose() {
        return this.rightArmPose;
    }

    public void setRightArmPose(class_2379 pose) {
        this.rightArmPose = pose;
        this.field_6011.method_12778(DATA_RIGHT_ARM_POSE, (Object)pose);
    }

    public boolean method_5698(class_1297 entity) {
        return entity instanceof class_1657 && !this.field_6002.method_8505((class_1657)entity, this.method_24515());
    }

    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    protected class_3414 method_6041(int damage) {
        return Mannequins.mannequinFallSound.get();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return Mannequins.mannequinHitSound.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return Mannequins.mannequinBreakSound.get();
    }

    public void method_5800(class_3218 level, class_1538 lightning) {
    }

    public boolean method_6086() {
        return false;
    }

    public boolean method_6102() {
        return false;
    }
}

