/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.mannequins.bridge.forge;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import me.jaackson.mannequins.common.network.MannequinsPacket;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkBridgeImpl {
    public static final SimpleChannel PLAY = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("mannequins", "play")).networkProtocolVersion(() -> "1").clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).simpleChannel();
    private static int currentIndex = -1;

    public static <T> void registerClientbound(ResourceLocation channel, Class<T> messageType, BiConsumer<T, PacketBuffer> write, Function<PacketBuffer, T> read, Consumer<T> handle) {
        PLAY.registerMessage(currentIndex++, messageType, write, read, (packet, context) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)context.get();
            if (ctx.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                ctx.enqueueWork(() -> handle.accept(packet));
                ctx.setPacketHandled(true);
            }
        }, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public static <T> void registerServerbound(ResourceLocation channel, Class<T> messageType, BiConsumer<T, PacketBuffer> write, Function<PacketBuffer, T> read, BiConsumer<T, PlayerEntity> handle) {
        PLAY.registerMessage(currentIndex++, messageType, write, read, (packet, context) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)context.get();
            if (ctx.getDirection().getReceptionSide() == LogicalSide.SERVER) {
                ctx.enqueueWork(() -> {
                    if (ctx.getSender() == null) {
                        return;
                    }
                    ServerPlayerEntity player = ctx.getSender();
                    handle.accept((Object)packet, (PlayerEntity)player);
                });
                ctx.setPacketHandled(true);
            }
        }, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    public static void sendClientbound(ResourceLocation channel, ServerPlayerEntity player, MannequinsPacket packet) {
        PLAY.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public static void sendClientboundTracking(ResourceLocation channel, Entity tracking, MannequinsPacket packet) {
        PLAY.send(PacketDistributor.TRACKING_ENTITY.with(() -> tracking), (Object)packet);
    }

    public static void sendServerbound(ResourceLocation channel, MannequinsPacket packet) {
        PLAY.sendToServer((Object)packet);
    }
}

