/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.mannequins.bridge.forge;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class RegistryBridgeImpl {
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"mannequins");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"mannequins");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"mannequins");

    public static <T extends SoundEvent> Supplier<T> registerSound(String name, T event) {
        return SOUND_EVENTS.register(name, () -> event);
    }

    public static <T extends Item> Supplier<T> registerItem(String name, T item) {
        return ITEMS.register(name, () -> item);
    }

    public static <T extends Entity, V extends EntityType<T>> Supplier<V> registerEntity(String name, V type) {
        return ENTITIES.register(name, () -> type);
    }

    public static <T extends LivingEntity> void registerEntityAttributes(Supplier<EntityType<T>> type, Supplier<AttributeModifierMap.MutableAttribute> builder) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(e -> e.put((EntityType)type.get(), ((AttributeModifierMap.MutableAttribute)builder.get()).func_233813_a_()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <T extends Entity> void registerEntityRenderer(EntityType<T> entity, Function<EntityRendererManager, EntityRenderer<T>> renderer) {
        EntityRendererManager dispatcher = Minecraft.func_71410_x().func_175598_ae();
        dispatcher.func_229087_a_(entity, renderer.apply(dispatcher));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerSprite(ResourceLocation sprite, ResourceLocation atlas) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(e -> {
            AtlasTexture texture = e.getMap();
            if (atlas.equals((Object)texture.func_229223_g_())) {
                e.addSprite(sprite);
            }
        });
    }
}

