/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.mannequins.common.entity;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import me.jaackson.mannequins.Mannequins;
import me.jaackson.mannequins.bridge.EventBridge;
import me.jaackson.mannequins.bridge.NetworkBridge;
import me.jaackson.mannequins.bridge.PlayerBridge;
import me.jaackson.mannequins.common.menu.MannequinInventoryMenu;
import me.jaackson.mannequins.common.network.ClientboundAttackMannequin;
import me.jaackson.mannequins.common.network.ClientboundOpenMannequinScreen;
import me.shedaniel.architectury.annotations.PlatformOnly;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class Mannequin
extends LivingEntity {
    public static final DataParameter<Rotations> DATA_HEAD_POSE = EntityDataManager.func_187226_a(Mannequin.class, (IDataSerializer)DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> DATA_BODY_POSE = EntityDataManager.func_187226_a(Mannequin.class, (IDataSerializer)DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> DATA_LEFT_ARM_POSE = EntityDataManager.func_187226_a(Mannequin.class, (IDataSerializer)DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> DATA_RIGHT_ARM_POSE = EntityDataManager.func_187226_a(Mannequin.class, (IDataSerializer)DataSerializers.field_187199_i);
    public static final DataParameter<Boolean> DATA_DISABLED = EntityDataManager.func_187226_a(Mannequin.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Predicate<Entity> MINECART = entity -> entity instanceof AbstractMinecartEntity && ((AbstractMinecartEntity)entity).func_184264_v() == AbstractMinecartEntity.Type.RIDEABLE;
    private static final Rotations DEFAULT_HEAD_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_BODY_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_LEFT_ARM_POSE = new Rotations(-10.0f, 0.0f, -10.0f);
    private static final Rotations DEFAULT_RIGHT_ARM_POSE = new Rotations(-10.0f, 0.0f, 10.0f);
    private final Inventory inventory = new Inventory(4);
    public long lastHit;
    private Rotations headPose = DEFAULT_HEAD_POSE;
    private Rotations bodyPose = DEFAULT_BODY_POSE;
    private Rotations leftArmPose = DEFAULT_LEFT_ARM_POSE;
    private Rotations rightArmPose = DEFAULT_RIGHT_ARM_POSE;
    private int attackAnimation;
    private float attackAnimationXFactor;
    private float attackAnimationZFactor;

    public Mannequin(EntityType<? extends Mannequin> type, World level) {
        super(type, level);
        this.field_70138_W = 0.0f;
    }

    public void onAttack(float attackYaw) {
        float rotation = attackYaw - (float)((double)this.field_70761_aq / 180.0 * Math.PI);
        this.field_70739_aP = attackYaw;
        this.attackAnimation = 40;
        this.attackAnimationXFactor = MathHelper.func_76134_b((float)rotation);
        this.attackAnimationZFactor = MathHelper.func_76126_a((float)rotation);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_HEAD_POSE, (Object)DEFAULT_HEAD_POSE);
        this.field_70180_af.func_187214_a(DATA_BODY_POSE, (Object)DEFAULT_BODY_POSE);
        this.field_70180_af.func_187214_a(DATA_LEFT_ARM_POSE, (Object)DEFAULT_LEFT_ARM_POSE);
        this.field_70180_af.func_187214_a(DATA_RIGHT_ARM_POSE, (Object)DEFAULT_RIGHT_ARM_POSE);
        this.field_70180_af.func_187214_a(DATA_DISABLED, (Object)false);
    }

    public Iterable<ItemStack> func_184214_aD() {
        return Collections.emptyList();
    }

    public Iterable<ItemStack> func_184193_aE() {
        return Collections.emptyList();
    }

    public ItemStack func_184582_a(EquipmentSlotType slot) {
        if (slot == null) {
            return ItemStack.field_190927_a;
        }
        switch (slot) {
            case HEAD: {
                return this.inventory.func_70301_a(0);
            }
            case CHEST: {
                return this.inventory.func_70301_a(1);
            }
            case MAINHAND: {
                return this.inventory.func_70301_a(2);
            }
            case OFFHAND: {
                return this.inventory.func_70301_a(3);
            }
        }
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slot, ItemStack stack) {
        if (slot == null) {
            return;
        }
        switch (slot) {
            case HEAD: {
                this.inventory.func_70299_a(0, stack);
                break;
            }
            case CHEST: {
                this.inventory.func_70299_a(1, stack);
                break;
            }
            case MAINHAND: {
                this.inventory.func_70299_a(2, stack);
                break;
            }
            case OFFHAND: {
                this.inventory.func_70299_a(3, stack);
            }
        }
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_218657_a("Pose", (INBT)this.writePose());
        tag.func_74757_a("Disabled", this.isDisabled());
        ListNBT listTag = new ListNBT();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = this.inventory.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            CompoundNBT compoundTag2 = new CompoundNBT();
            compoundTag2.func_74774_a("Slot", (byte)i);
            itemStack.func_77955_b(compoundTag2);
            listTag.add((Object)compoundTag2);
        }
        tag.func_218657_a("Items", (INBT)listTag);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.readPose(tag.func_74775_l("Pose"));
        this.field_70180_af.func_187227_b(DATA_DISABLED, (Object)tag.func_74767_n("Disabled"));
        ListNBT listTag = tag.func_150295_c("Items", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundNBT compoundTag2 = listTag.func_150305_b(i);
            int j = compoundTag2.func_74771_c("Slot") & 0xFF;
            if (j >= this.inventory.func_70302_i_()) continue;
            this.inventory.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)compoundTag2));
        }
    }

    private void readPose(CompoundNBT tag) {
        ListNBT headPose = tag.func_150295_c("Head", 5);
        this.setHeadPose(headPose.isEmpty() ? DEFAULT_HEAD_POSE : new Rotations(headPose));
        ListNBT bodyPose = tag.func_150295_c("Body", 5);
        this.setBodyPose(bodyPose.isEmpty() ? DEFAULT_BODY_POSE : new Rotations(bodyPose));
        ListNBT leftArmPose = tag.func_150295_c("LeftArm", 5);
        this.setLeftArmPose(leftArmPose.isEmpty() ? DEFAULT_LEFT_ARM_POSE : new Rotations(leftArmPose));
        ListNBT rightArmPose = tag.func_150295_c("RightArm", 5);
        this.setRightArmPose(rightArmPose.isEmpty() ? DEFAULT_RIGHT_ARM_POSE : new Rotations(rightArmPose));
    }

    private CompoundNBT writePose() {
        CompoundNBT pose = new CompoundNBT();
        if (!DEFAULT_HEAD_POSE.equals((Object)this.headPose)) {
            pose.func_218657_a("Head", (INBT)this.headPose.func_179414_a());
        }
        if (!DEFAULT_BODY_POSE.equals((Object)this.bodyPose)) {
            pose.func_218657_a("Body", (INBT)this.bodyPose.func_179414_a());
        }
        if (!DEFAULT_LEFT_ARM_POSE.equals((Object)this.leftArmPose)) {
            pose.func_218657_a("LeftArm", (INBT)this.leftArmPose.func_179414_a());
        }
        if (!DEFAULT_RIGHT_ARM_POSE.equals((Object)this.rightArmPose)) {
            pose.func_218657_a("RightArm", (INBT)this.rightArmPose.func_179414_a());
        }
        return pose;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entity) {
    }

    protected void func_85033_bc() {
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), MINECART);
        for (Entity entity : list) {
            if (!(this.func_70068_e(entity) <= 0.2)) continue;
            entity.func_70108_f((Entity)this);
        }
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (this.isDisabled()) {
            return ActionResultType.FAIL;
        }
        if (!player.func_184586_b(hand).func_190926_b() && !player.func_226563_dT_()) {
            return ActionResultType.PASS;
        }
        if (this.field_70170_p.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
        if (serverPlayer.field_71070_bA != serverPlayer.field_71069_bz) {
            serverPlayer.func_71053_j();
        }
        PlayerBridge.incrementContainerId(serverPlayer);
        NetworkBridge.sendClientbound(ClientboundOpenMannequinScreen.CHANNEL, serverPlayer, new ClientboundOpenMannequinScreen(PlayerBridge.getContainerId(serverPlayer), this.func_145782_y()));
        serverPlayer.field_71070_bA = new MannequinInventoryMenu(PlayerBridge.getContainerId(serverPlayer), serverPlayer.field_71071_by, (IInventory)this.inventory, this);
        serverPlayer.field_71070_bA.func_75132_a((IContainerListener)serverPlayer);
        EventBridge.fireContainerOpenEvent(serverPlayer, serverPlayer.field_71070_bA);
        return ActionResultType.CONSUME;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.func_201670_d() || !this.func_70089_S()) {
            return false;
        }
        if (DamageSource.field_76380_i.equals(source)) {
            this.func_70106_y();
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.func_94541_c()) {
            this.brokenByAnything(source);
            this.func_70106_y();
            return false;
        }
        if (DamageSource.field_76372_a.equals(source)) {
            if (this.func_70027_ad()) {
                this.causeDamage(source, 0.15f);
            } else {
                this.func_70015_d(5);
            }
            return false;
        }
        if (DamageSource.field_76370_b.equals(source) && this.func_110143_aJ() > 0.5f) {
            this.causeDamage(source, 4.0f);
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity == null || !(source.func_76364_f() instanceof PlayerEntity) || !entity.func_225608_bj_()) {
            Vector3d pos = source.func_188404_v();
            if (pos == null) {
                return false;
            }
            this.field_70739_aP = (float)(-MathHelper.func_181159_b((double)(pos.func_82615_a() - this.func_226277_ct_()), (double)(pos.func_82616_c() - this.func_226281_cx_())));
            this.field_70170_p.func_72960_a((Entity)this, (byte)32);
            NetworkBridge.sendClientboundTracking(ClientboundAttackMannequin.CHANNEL, (Entity)this, new ClientboundAttackMannequin(this.func_145782_y(), this.field_70739_aP));
            if (amount > 0.0f) {
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197615_h, this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_(), (int)((double)amount * 0.5), 0.1, 0.0, 0.1, 0.2);
            }
            return false;
        }
        if (source.func_76346_g() instanceof PlayerEntity && !((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75099_e) {
            return false;
        }
        if (source.func_180136_u()) {
            this.playBrokenSound();
            this.showBreakingParticles();
            this.func_70106_y();
            return true;
        }
        long time = this.field_70170_p.func_82737_E();
        if (time - this.lastHit > 5L) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)32);
            this.lastHit = time;
        } else {
            this.brokenByPlayer(source);
            this.showBreakingParticles();
            this.func_70106_y();
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte event) {
        if (event == 32) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), Mannequins.mannequinHitSound.get(), this.func_184176_by(), 0.3f, 1.0f, false);
                this.lastHit = this.field_70170_p.func_82737_E();
            }
        } else {
            super.func_70103_a(event);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0) || d0 == 0.0) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    private void showBreakingParticles() {
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196662_n.func_176223_P()), this.func_226277_ct_(), this.func_226283_e_(0.6666666666666666), this.func_226281_cx_(), 10, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
        }
    }

    private void causeDamage(DamageSource source, float damage) {
        float f = this.func_110143_aJ();
        if ((f -= damage) <= 0.5f) {
            this.brokenByAnything(source);
            this.func_70106_y();
        } else {
            this.func_70606_j(f);
        }
    }

    private void brokenByPlayer(DamageSource source) {
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_233580_cy_(), (ItemStack)new ItemStack((IItemProvider)Mannequins.mannequinItem.get()));
        this.brokenByAnything(source);
    }

    private void brokenByAnything(DamageSource source) {
        this.playBrokenSound();
        this.func_213345_d(source);
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_233580_cy_().func_177984_a(), (ItemStack)stack);
            this.inventory.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    private void playBrokenSound() {
        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), Mannequins.mannequinBreakSound.get(), this.func_184176_by(), 1.0f, 1.0f);
    }

    protected float func_110146_f(float p_110146_1_, float p_110146_2_) {
        this.field_70760_ar = this.field_70126_B;
        this.field_70761_aq = this.field_70177_z;
        return 0.0f;
    }

    protected float func_213348_b(Pose pose, EntitySize dimensions) {
        return dimensions.field_220316_b * 0.86f;
    }

    public double func_70033_W() {
        return 0.1f;
    }

    public void func_181013_g(float rot) {
        this.field_70760_ar = this.field_70126_B = rot;
        this.field_70758_at = this.field_70759_as = rot;
    }

    public void func_70034_d(float rot) {
        this.field_70760_ar = this.field_70126_B = rot;
        this.field_70758_at = this.field_70759_as = rot;
    }

    public void func_70071_h_() {
        Rotations rightArmPose;
        Rotations leftArmPose;
        Rotations bodyPose;
        super.func_70071_h_();
        Rotations headPose = (Rotations)this.field_70180_af.func_187225_a(DATA_HEAD_POSE);
        if (!this.headPose.equals((Object)headPose)) {
            this.setHeadPose(headPose);
        }
        if (!this.bodyPose.equals((Object)(bodyPose = (Rotations)this.field_70180_af.func_187225_a(DATA_BODY_POSE)))) {
            this.setBodyPose(bodyPose);
        }
        if (!this.leftArmPose.equals((Object)(leftArmPose = (Rotations)this.field_70180_af.func_187225_a(DATA_LEFT_ARM_POSE)))) {
            this.setLeftArmPose(leftArmPose);
        }
        if (!this.rightArmPose.equals((Object)(rightArmPose = (Rotations)this.field_70180_af.func_187225_a(DATA_RIGHT_ARM_POSE)))) {
            this.setRightArmPose(rightArmPose);
        }
        if (this.field_70170_p.func_201670_d()) {
            if (this.attackAnimation <= 0) {
                return;
            }
            --this.attackAnimation;
        }
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    private float getAttackAnimation(float partialTicks) {
        float x = (float)this.attackAnimation - partialTicks;
        return MathHelper.func_76134_b((float)x) / 2.0f * MathHelper.func_76129_c((float)x) / (50.0f - x);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasAnimation() {
        return this.attackAnimation > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationRotationX(float partialTicks) {
        return this.attackAnimationXFactor * this.getAttackAnimation(partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationRotationZ(float partialTicks) {
        return this.attackAnimationZFactor * this.getAttackAnimation(partialTicks);
    }

    public boolean isDisabled() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_DISABLED);
    }

    public Rotations getHeadPose() {
        return this.headPose;
    }

    public void setHeadPose(Rotations pose) {
        this.headPose = pose;
        this.field_70180_af.func_187227_b(DATA_HEAD_POSE, (Object)pose);
    }

    public Rotations getBodyPose() {
        return this.bodyPose;
    }

    public void setBodyPose(Rotations pose) {
        this.bodyPose = pose;
        this.field_70180_af.func_187227_b(DATA_BODY_POSE, (Object)pose);
    }

    public Rotations getLeftArmPose() {
        return this.leftArmPose;
    }

    public void setLeftArmPose(Rotations pose) {
        this.leftArmPose = pose;
        this.field_70180_af.func_187227_b(DATA_LEFT_ARM_POSE, (Object)pose);
    }

    public Rotations getRightArmPose() {
        return this.rightArmPose;
    }

    public void setRightArmPose(Rotations pose) {
        this.rightArmPose = pose;
        this.field_70180_af.func_187227_b(DATA_RIGHT_ARM_POSE, (Object)pose);
    }

    public boolean func_85031_j(Entity entity) {
        return entity instanceof PlayerEntity && !this.field_70170_p.func_175660_a((PlayerEntity)entity, this.func_233580_cy_());
    }

    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }

    protected SoundEvent func_184588_d(int damage) {
        return Mannequins.mannequinFallSound.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return Mannequins.mannequinHitSound.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return Mannequins.mannequinBreakSound.get();
    }

    public void func_241841_a(ServerWorld level, LightningBoltEntity lightning) {
    }

    public boolean func_184603_cC() {
        return false;
    }

    public boolean func_190631_cK() {
        return false;
    }

    @PlatformOnly(value={"forge"})
    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)Mannequins.mannequinItem.get());
    }
}

