/*
 * Decompiled with CFR 0.152.
 */
package me.jaackson.mannequins.common.network;

import me.jaackson.mannequins.bridge.PlayerBridge;
import me.jaackson.mannequins.common.menu.MannequinInventoryMenu;
import me.jaackson.mannequins.common.network.MannequinsPacket;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ServerboundSetMannequinPose
implements MannequinsPacket {
    public static final ResourceLocation CHANNEL = new ResourceLocation("mannequins", "set_mannequin_pose");
    private static final ITextComponent DISCONNECT_MESSAGE = new TranslationTextComponent("disconnect.mannequins.invalid_mannequin_pose");
    private final int containerId;
    private final Rotations headRotations;
    private final Rotations bodyRotations;
    private final Rotations leftArmRotations;
    private final Rotations rightArmRotations;

    public ServerboundSetMannequinPose(int id, Rotations headRotations, Rotations bodyRotations, Rotations leftArmRotations, Rotations rightArmRotations) {
        this.containerId = id;
        this.headRotations = headRotations;
        this.bodyRotations = bodyRotations;
        this.leftArmRotations = leftArmRotations;
        this.rightArmRotations = rightArmRotations;
    }

    private static void writeRotations(PacketBuffer buf, Rotations rotations) {
        buf.writeFloat(rotations.func_179415_b());
        buf.writeFloat(rotations.func_179416_c());
        buf.writeFloat(rotations.func_179413_d());
    }

    private static Rotations readRotations(PacketBuffer buf) {
        return new Rotations(buf.readFloat(), buf.readFloat(), buf.readFloat());
    }

    public static ServerboundSetMannequinPose read(PacketBuffer buf) {
        return new ServerboundSetMannequinPose(buf.readUnsignedByte(), ServerboundSetMannequinPose.readRotations(buf), ServerboundSetMannequinPose.readRotations(buf), ServerboundSetMannequinPose.readRotations(buf), ServerboundSetMannequinPose.readRotations(buf));
    }

    public static void handle(ServerboundSetMannequinPose packet, PlayerEntity player) {
        if (!(player instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
        if (PlayerBridge.getContainerId(serverPlayer) != packet.containerId) {
            return;
        }
        if (!(serverPlayer.field_71070_bA instanceof MannequinInventoryMenu) || !serverPlayer.field_71070_bA.func_75145_c((PlayerEntity)serverPlayer)) {
            serverPlayer.field_71135_a.func_194028_b(DISCONNECT_MESSAGE);
            return;
        }
        ((MannequinInventoryMenu)serverPlayer.field_71070_bA).setMannequinPose(packet.headRotations, packet.bodyRotations, packet.leftArmRotations, packet.rightArmRotations);
    }

    @Override
    public PacketBuffer write(PacketBuffer buf) {
        buf.writeByte(this.containerId);
        ServerboundSetMannequinPose.writeRotations(buf, this.headRotations);
        ServerboundSetMannequinPose.writeRotations(buf, this.bodyRotations);
        ServerboundSetMannequinPose.writeRotations(buf, this.leftArmRotations);
        ServerboundSetMannequinPose.writeRotations(buf, this.rightArmRotations);
        return buf;
    }
}

