/*
 * Decompiled with CFR 0.152.
 */
package com.meepshadow.mysticsbiomes.client.entity;

import com.meepshadow.mysticsbiomes.core.registry.ModBlocks;
import com.meepshadow.mysticsbiomes.core.registry.ModItems;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StrawberryCowEntity
extends AnimalEntity {
    private static final DataParameter<String> STRAWBERRY_COW_TYPE = EntityDataManager.func_187226_a(StrawberryCowEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private Effect hasStewEffect;
    private int effectDuration;
    private UUID lightningUUID;

    public StrawberryCowEntity(EntityType<? extends StrawberryCowEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 2.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151015_O}), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187558_ak;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187562_am;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187560_al;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.15f, 1.0f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151133_ar && !player.field_71075_bZ.field_75098_d && !this.func_70631_g_()) {
            player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
            itemstack.func_190918_g(1);
            if (itemstack.func_190926_b()) {
                player.func_184611_a(hand, new ItemStack((IItemProvider)ModItems.STRAWBERRY_MILK_BUCKET.get()));
            } else if (!player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)ModItems.STRAWBERRY_MILK_BUCKET.get()))) {
                player.func_71019_a(new ItemStack((IItemProvider)ModItems.STRAWBERRY_MILK_BUCKET.get()), false);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public CowEntity createChild(AgeableEntity ageable) {
        return (CowEntity)EntityType.field_200796_j.func_200721_a(this.field_70170_p);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? sizeIn.field_220316_b * 0.95f : 1.3f;
    }

    public void func_70077_a(LightningBoltEntity lightningBolt) {
        UUID uuid = lightningBolt.func_110124_au();
        if (!uuid.equals(this.lightningUUID)) {
            this.setStrawberryCowType(this.getStrawberryCowType() == Type.RED ? Type.PINK : Type.RED);
            this.lightningUUID = uuid;
            this.func_184185_a(SoundEvents.field_219658_gv, 2.0f, 1.0f);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STRAWBERRY_COW_TYPE, (Object)Type.RED.name);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("Type", this.getStrawberryCowType().name);
        if (this.hasStewEffect != null) {
            compound.func_74774_a("EffectId", (byte)Effect.func_188409_a((Effect)this.hasStewEffect));
            compound.func_74768_a("EffectDuration", this.effectDuration);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setStrawberryCowType(Type.getTypeByName(compound.func_74779_i("Type")));
        if (compound.func_150297_b("EffectId", 1)) {
            this.hasStewEffect = Effect.func_188412_a((int)compound.func_74771_c("EffectId"));
        }
        if (compound.func_150297_b("EffectDuration", 3)) {
            this.effectDuration = compound.func_74762_e("EffectDuration");
        }
    }

    private void setStrawberryCowType(Type typeIn) {
        this.field_70180_af.func_187227_b(STRAWBERRY_COW_TYPE, (Object)typeIn.name);
    }

    public Type getStrawberryCowType() {
        return Type.getTypeByName((String)this.field_70180_af.func_187225_a(StrawberryCowEntity.STRAWBERRY_COW_TYPE));
    }

    private Type func_213445_a(StrawberryCowEntity p_213445_1_) {
        Type strawberrycowentity$type1;
        Type strawberrycowentity$type = this.getStrawberryCowType();
        Type strawberrycowentity$type2 = strawberrycowentity$type == (strawberrycowentity$type1 = p_213445_1_.getStrawberryCowType()) && this.field_70146_Z.nextInt(1024) == 0 ? (strawberrycowentity$type == Type.PINK ? Type.RED : Type.PINK) : (this.field_70146_Z.nextBoolean() ? strawberrycowentity$type : strawberrycowentity$type1);
        return strawberrycowentity$type2;
    }

    public static enum Type {
        RED("red", ((Block)ModBlocks.STRAWBERRY_FLOWER.get()).func_176223_P()),
        PINK("pink", ((Block)ModBlocks.PINK_DAISY_BUSH.get()).func_176223_P());

        private final String name;
        private final BlockState renderState;

        private Type(String nameIn, BlockState renderStateIn) {
            this.name = nameIn;
            this.renderState = renderStateIn;
        }

        @OnlyIn(value=Dist.CLIENT)
        public BlockState getRenderState() {
            return this.renderState;
        }

        private static Type getTypeByName(String nameIn) {
            for (Type strawberrycowentity$type : Type.values()) {
                if (!strawberrycowentity$type.name.equals(nameIn)) continue;
                return strawberrycowentity$type;
            }
            return RED;
        }
    }
}

