/*
 * Decompiled with CFR 0.152.
 */
package com.meepshadow.mysticsbiomes.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class DirectionalVerticalSlabBlock
extends Block
implements IWaterLoggable {
    public static final EnumProperty<VerticalSlabType> TYPE = EnumProperty.func_177709_a((String)"type", VerticalSlabType.class);
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape EAST_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape NORTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape DOUBLE_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public DirectionalVerticalSlabBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, TYPE, WATERLOGGED});
    }

    public boolean func_220074_n(BlockState state) {
        return state.func_177229_b(TYPE) != VerticalSlabType.DOUBLE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (state.func_177229_b(TYPE) == VerticalSlabType.HALF) {
            switch ((Direction)state.func_177229_b((IProperty)FACING)) {
                default: {
                    return NORTH_AABB;
                }
                case SOUTH: {
                    return SOUTH_AABB;
                }
                case WEST: {
                    return WEST_AABB;
                }
                case EAST: 
            }
            return EAST_AABB;
        }
        return DOUBLE_AABB;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        BlockState blockstate = context.func_195991_k().func_180495_p(blockpos);
        if (blockstate.func_177230_c() == this) {
            return (BlockState)((BlockState)blockstate.func_206870_a(TYPE, (Comparable)((Object)VerticalSlabType.DOUBLE))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        IFluidState fluid = context.func_195991_k().func_204610_c(blockpos);
        BlockState retState = (BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.func_206886_c() == Fluids.field_204546_a));
        Direction direction = DirectionalVerticalSlabBlock.getDirectionForPlacement(context);
        return (BlockState)retState.func_206870_a((IProperty)FACING, (Comparable)direction);
    }

    private static Direction getDirectionForPlacement(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        if (direction.func_176740_k() != Direction.Axis.Y) {
            return direction;
        }
        Vec3d vec = context.func_221532_j().func_178788_d(new Vec3d((Vec3i)context.func_195995_a())).func_178786_a(0.5, 0.0, 0.5);
        double angle = Math.atan2(vec.field_72450_a, vec.field_72449_c) * -180.0 / Math.PI;
        return Direction.func_176733_a((double)angle).func_176734_d();
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        ItemStack itemstack = useContext.func_195996_i();
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        VerticalSlabType slabtype = (VerticalSlabType)((Object)state.func_177229_b(TYPE));
        return slabtype != VerticalSlabType.DOUBLE && itemstack.func_77973_b() == this.func_199767_j() && useContext.func_196012_c() && useContext.func_196000_l() == direction && DirectionalVerticalSlabBlock.getDirectionForPlacement(useContext) == direction;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, IFluidState fluidStateIn) {
        return state.func_177229_b(TYPE) != VerticalSlabType.DOUBLE && super.func_204509_a(worldIn, pos, state, fluidStateIn);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return state.func_177229_b(TYPE) != VerticalSlabType.DOUBLE && super.func_204510_a(worldIn, pos, state, fluidIn);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return type == PathType.WATER && worldIn.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a);
    }

    public static enum VerticalSlabType implements IStringSerializable
    {
        HALF("half"),
        DOUBLE("double");

        private final String name;

        private VerticalSlabType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

