/*
 * Decompiled with CFR 0.152.
 */
package com.meepshadow.mysticsbiomes.common.block.wood;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ModTrapDoor
extends HorizontalBlock
implements IWaterLoggable {
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    public static final EnumProperty<Half> HALF = BlockStateProperties.field_208164_Q;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape EAST_OPEN_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_OPEN_AABB = Block.func_208617_a((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_OPEN_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_OPEN_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape BOTTOM_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    protected static final VoxelShape TOP_AABB = Block.func_208617_a((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public ModTrapDoor(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((IProperty)OPEN, (Comparable)Boolean.FALSE)).func_206870_a(HALF, (Comparable)Half.BOTTOM)).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (!((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
            return state.func_177229_b(HALF) == Half.TOP ? TOP_AABB : BOTTOM_AABB;
        }
        switch ((Direction)state.func_177229_b((IProperty)field_185512_D)) {
            default: {
                return NORTH_OPEN_AABB;
            }
            case SOUTH: {
                return SOUTH_OPEN_AABB;
            }
            case WEST: {
                return WEST_OPEN_AABB;
            }
            case EAST: 
        }
        return EAST_OPEN_AABB;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: 
            case AIR: {
                return (Boolean)state.func_177229_b((IProperty)OPEN);
            }
            case WATER: {
                return (Boolean)state.func_177229_b((IProperty)WATERLOGGED);
            }
        }
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (this.field_149764_J == Material.field_151573_f) {
            return ActionResultType.PASS;
        }
        state = (BlockState)state.func_177231_a((IProperty)OPEN);
        worldIn.func_180501_a(pos, state, 2);
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        this.playSound(player, worldIn, pos, (Boolean)state.func_177229_b((IProperty)OPEN));
        return ActionResultType.SUCCESS;
    }

    protected void playSound(@Nullable PlayerEntity player, World worldIn, BlockPos pos, boolean p_185731_4_) {
        if (p_185731_4_) {
            int i = this.field_149764_J == Material.field_151573_f ? 1037 : 1007;
            worldIn.func_217378_a(player, i, pos, 0);
        } else {
            int j = this.field_149764_J == Material.field_151573_f ? 1036 : 1013;
            worldIn.func_217378_a(player, j, pos, 0);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!worldIn.field_72995_K && (flag = worldIn.func_175640_z(pos)) != (Boolean)state.func_177229_b((IProperty)POWERED)) {
            if ((Boolean)state.func_177229_b((IProperty)OPEN) != flag) {
                state = (BlockState)state.func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(flag));
                this.playSound(null, worldIn, pos, flag);
            }
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(flag)), 2);
            if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
                worldIn.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
            }
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = this.func_176223_P();
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        Direction direction = context.func_196000_l();
        blockstate = !context.func_196012_c() && direction.func_176740_k().func_176722_c() ? (BlockState)((BlockState)blockstate.func_206870_a((IProperty)field_185512_D, (Comparable)direction)).func_206870_a(HALF, (Comparable)(context.func_221532_j().field_72448_b - (double)context.func_195995_a().func_177956_o() > 0.5 ? Half.TOP : Half.BOTTOM)) : (BlockState)((BlockState)blockstate.func_206870_a((IProperty)field_185512_D, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a(HALF, (Comparable)(direction == Direction.UP ? Half.BOTTOM : Half.TOP));
        if (context.func_195991_k().func_175640_z(context.func_195995_a())) {
            blockstate = (BlockState)((BlockState)blockstate.func_206870_a((IProperty)OPEN, (Comparable)Boolean.TRUE)).func_206870_a((IProperty)POWERED, (Comparable)Boolean.TRUE);
        }
        return (BlockState)blockstate.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D, OPEN, HALF, POWERED, WATERLOGGED});
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        BlockState down;
        if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue() && (down = world.func_180495_p(pos.func_177977_b())).func_177230_c() == Blocks.field_150468_ap) {
            return down.func_177229_b((IProperty)LadderBlock.field_176382_a) == state.func_177229_b((IProperty)field_185512_D);
        }
        return false;
    }

    public boolean func_220067_a(BlockState state, IBlockReader worldIn, BlockPos pos, EntityType<?> type) {
        return false;
    }
}

