/*
 * Decompiled with CFR 0.152.
 */
package com.meepshadow.mysticsbiomes.core.registry;

import com.meepshadow.mysticsbiomes.common.biome.CherryBlossomValleyBiome;
import com.meepshadow.mysticsbiomes.common.biome.LavenderMeadowBiome;
import com.meepshadow.mysticsbiomes.common.biome.StrawberryFieldBiome;
import com.meepshadow.mysticsbiomes.core.Config;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="mysticsbiomes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBiomes {
    public static final DeferredRegister<Biome> BIOMES = new DeferredRegister(ForgeRegistries.BIOMES, "mysticsbiomes");
    public static final RegistryObject<Biome> LAVENDER_MEADOW = BIOMES.register("lavender_meadow", LavenderMeadowBiome::new);
    public static final RegistryObject<Biome> STRAWBERRY_FIELD = BIOMES.register("strawberry_field", StrawberryFieldBiome::new);
    public static final RegistryObject<Biome> CHERRY_BLOSSOM_VALLEY = BIOMES.register("cherry_blossom_valley", CherryBlossomValleyBiome::new);

    public static void setupBiomes() {
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)LAVENDER_MEADOW.get(), ((Integer)Config.COMMON.lavenderMeadowWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)STRAWBERRY_FIELD.get(), ((Integer)Config.COMMON.strawberryFieldWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)CHERRY_BLOSSOM_VALLEY.get(), ((Integer)Config.COMMON.cherryBlossomValleyWeight.get()).intValue()));
        BiomeDictionary.addTypes((Biome)((Biome)LAVENDER_MEADOW.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)STRAWBERRY_FIELD.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)CHERRY_BLOSSOM_VALLEY.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.RARE, BiomeDictionary.Type.OVERWORLD});
    }
}

