/*
 * Decompiled with CFR 0.152.
 */
package com.meepshadow.mysticsbiomes.core.registry;

import com.meepshadow.mysticsbiomes.client.entity.StrawberryCowEntity;
import com.meepshadow.mysticsbiomes.client.entity.render.StrawberryCowRenderer;
import com.meepshadow.mysticsbiomes.core.Config;
import com.meepshadow.mysticsbiomes.core.registry.ModBiomes;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = new DeferredRegister(ForgeRegistries.ENTITIES, "mysticsbiomes");
    public static final RegistryObject<EntityType<StrawberryCowEntity>> STRAWBERRY_COW = ENTITIES.register("strawberry_cow", () -> EntityType.Builder.func_220322_a(StrawberryCowEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.9f, 1.4f).func_206830_a(new ResourceLocation("mysticsbiomes", "strawberry_cow").toString()));

    public static void setupEntitySpawns(Biome biome) {
        if (biome == ModBiomes.STRAWBERRY_FIELD.get()) {
            ModEntities.addEntitySpawn(biome, EntityClassification.CREATURE, new Biome.SpawnListEntry((EntityType)STRAWBERRY_COW.get(), 12, 2, 4));
        }
        if (((List)Config.COMMON.strawberryCowBiomes.get()).contains(biome.getRegistryName().toString())) {
            ModEntities.addEntitySpawn(biome, EntityClassification.CREATURE, new Biome.SpawnListEntry((EntityType)STRAWBERRY_COW.get(), 10, 2, 4));
        }
    }

    private static void addEntitySpawn(Biome biome, EntityClassification entityclassification, Biome.SpawnListEntry spawnlistentry) {
        biome.func_76747_a(entityclassification).add(spawnlistentry);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setupEntitiesClient() {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)STRAWBERRY_COW.get()), StrawberryCowRenderer::new);
    }
}

