/*
 * Decompiled with CFR 0.152.
 */
package com.jayhill.mysticsbiomes.common.block;

import com.jayhill.mysticsbiomes.init.ModItems;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IForgeShearable;

public class CherryVineBlock
extends Block
implements IForgeShearable,
IGrowable {
    public static final IntegerProperty AGE = IntegerProperty.func_177719_a((String)"age", (int)0, (int)4);
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)4.0, (double)5.0, (double)13.0, (double)16.0, (double)13.0);

    public CherryVineBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Vector3d Vector3d2 = state.func_191059_e(worldIn, pos);
        return SHAPE.func_197751_a(Vector3d2.field_72450_a, Vector3d2.field_72448_b, Vector3d2.field_72449_c);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        super.func_225534_a_(state, worldIn, pos, rand);
        int i = (Integer)state.func_177229_b((Property)AGE);
        if (i < 4 && worldIn.func_226659_b_(pos.func_177984_a(), 0) >= 7 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt(5) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        boolean flag;
        int i = (Integer)state.func_177229_b((Property)AGE);
        boolean bl = flag = i == 4;
        if (!flag && player.func_184586_b(handIn).func_77973_b() == Items.field_196106_bc) {
            return ActionResultType.PASS;
        }
        if (player.func_184586_b(handIn).func_77973_b() == Items.field_151097_aZ) {
            player.func_184586_b(handIn).func_222118_a(1, (LivingEntity)player, onBroken -> onBroken.func_213334_d(handIn));
            worldIn.func_184133_a(null, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            if ((Integer)state.func_177229_b((Property)AGE) == 4) {
                CherryVineBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)ModItems.CHERRIES.get(), 1));
            }
            return ActionResultType.SUCCESS;
        }
        if (flag) {
            CherryVineBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)ModItems.CHERRIES.get(), 2));
            worldIn.func_184133_a(null, pos, SoundEvents.field_219693_lB, SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    protected boolean isStateValid(World worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        return block.func_203417_a((ITag)BlockTags.field_206952_E) || block.func_203417_a((ITag)BlockTags.field_200031_h);
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XZ;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE});
    }

    public boolean func_176473_a(IBlockReader arg0, BlockPos arg1, BlockState state, boolean arg3) {
        return (Integer)state.func_177229_b((Property)AGE) < 4;
    }

    public boolean func_180670_a(World arg0, Random arg1, BlockPos arg2, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        int i = (Integer)state.func_177229_b((Property)AGE);
        if (i < 4 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (boolean)true)) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i + 1)));
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (this.isStateValid(world, pos)) {
            return this.func_176223_P();
        }
        return null;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }
}

