/*
 * Decompiled with CFR 0.152.
 */
package com.jayhill.mysticsbiomes.common.world.feature;

import com.jayhill.mysticsbiomes.init.ModFeatures;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Features;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class ModBiomeFeatures {
    public static void addVanillaFeatures(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder builder = event.getGeneration();
        if (!event.getName().toString().startsWith("minecraft:") || ModBiomeFeatures.doesBiomeMatch(event.getName(), (RegistryKey<Biome>)Biomes.field_185444_T)) {
            // empty if block
        }
    }

    public static void withStrawberryFieldsFeatures(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.Configured.STRAWBERRY_BLOSSOM_TREES);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.Configured.SWEET_BLOSSOM_TREES);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.Configured.SMALL_PEONY_TREES);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.Configured.GRASS);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.Configured.STRAWBERRY_BUSHES);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.Configured.WILDFLOWERS);
    }

    public static void withLavenderMeadowFeatures(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.Configured.LAVENDER_BLOSSOM_TREES);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.Configured.SMALL_PEONY_TREES);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.Configured.GRASS);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.Configured.LAVENDER_FLOWERS);
    }

    public static void withBambooBlossomForestFeatures(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.Configured.PINK_CHERRY_BLOSSOM_TREES);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.Configured.WHITE_CHERRY_BLOSSOM_TREES);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.Configured.PEONY_TREES);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.Configured.PEONY_BUSHES);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.Configured.LILAC_FLOWERS);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.Configured.GRASS);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.Configured.BAMBOO_LIGHT);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModFeatures.Configured.BAMBOO_DENSE);
    }

    public static void withSugarCane(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243820_aS);
    }

    public static boolean doesBiomeMatch(ResourceLocation biomeNameIn, RegistryKey<Biome> biomeIn) {
        return biomeNameIn.func_110623_a().matches(biomeIn.func_240901_a_().func_110623_a());
    }
}

