/*
 * Decompiled with CFR 0.152.
 */
package com.jayhill.mysticsbiomes.core;

import com.jayhill.mysticsbiomes.common.world.feature.ModBiomeFeatures;
import com.jayhill.mysticsbiomes.core.BiomeConfigs;
import com.jayhill.mysticsbiomes.core.register.RegisterClient;
import com.jayhill.mysticsbiomes.core.register.RegisterCommon;
import com.jayhill.mysticsbiomes.init.ModBiomes;
import com.jayhill.mysticsbiomes.init.ModBlocks;
import com.jayhill.mysticsbiomes.init.ModEntities;
import com.jayhill.mysticsbiomes.init.ModFeatures;
import com.jayhill.mysticsbiomes.init.ModItems;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="mysticsbiomes")
public class MysticsBiomes {
    public static final String MOD_ID = "mysticsbiomes";
    public static final ItemGroup TAB = new ItemGroup("mysticsbiomesTab"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ModItems.LOGO.get());
        }
    };

    public MysticsBiomes() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> modEventBus.addListener(this::clientSetup));
        modEventBus.addListener(EventPriority.LOWEST, this::commonSetup);
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModBiomes.BIOMES.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, BiomeConfigs.COMMON_SPEC);
        MinecraftForge.EVENT_BUS.addListener(ModBiomeFeatures::addVanillaFeatures);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            RegisterCommon.registerCompostables();
            ModBiomes.registerBiomes(event);
            ModEntities.registerEntities();
            ModEntities.registerEntitySpawns();
            ModFeatures.Configured.registerConfiguredFeatures();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(RegisterClient::registerRenderLayers);
        ModEntities.setupEntitiesClient();
    }
}

