/*
 * Decompiled with CFR 0.152.
 */
package com.jayhill.mysticsbiomes.init;

import com.jayhill.mysticsbiomes.common.biome.overworld.BambooBlossomForestBiome;
import com.jayhill.mysticsbiomes.common.biome.overworld.LavenderMeadowBiome;
import com.jayhill.mysticsbiomes.common.biome.overworld.StrawberryFieldsBiome;
import com.jayhill.mysticsbiomes.core.BiomeConfigs;
import java.util.Objects;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="mysticsbiomes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBiomes {
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"mysticsbiomes");
    public static final RegistryObject<Biome> BAMBOO_BLOSSOM_FOREST = BIOMES.register("bamboo_blossom_forest", BambooBlossomForestBiome::makeBambooBlossomForestBiome);
    public static final RegistryObject<Biome> STRAWBERRY_FIELDS = BIOMES.register("strawberry_fields", StrawberryFieldsBiome::makeStrawberryFieldBiome);
    public static final RegistryObject<Biome> LAVENDER_MEADOW = BIOMES.register("lavender_meadow", LavenderMeadowBiome::makeLavenderMeadowBiome);

    @SubscribeEvent
    public static void registerBiomes(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModBiomes.setupBiome((Biome)BAMBOO_BLOSSOM_FOREST.get(), BiomeManager.BiomeType.COOL, (Integer)BiomeConfigs.COMMON.bambooBlossomForestWeight.get(), BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.OVERWORLD);
            ModBiomes.setupBiome((Biome)STRAWBERRY_FIELDS.get(), BiomeManager.BiomeType.WARM, (Integer)BiomeConfigs.COMMON.strawberryFieldsWeight.get(), BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.OVERWORLD);
            ModBiomes.setupBiome((Biome)LAVENDER_MEADOW.get(), BiomeManager.BiomeType.COOL, (Integer)BiomeConfigs.COMMON.lavenderMeadowWeight.get(), BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.RARE, BiomeDictionary.Type.OVERWORLD);
        });
    }

    private static void setupBiome(Biome biome, BiomeManager.BiomeType biomeType, int weight, BiomeDictionary.Type ... types) {
        BiomeDictionary.addTypes(ModBiomes.key(biome), (BiomeDictionary.Type[])types);
        BiomeManager.addBiome((BiomeManager.BiomeType)biomeType, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(ModBiomes.key(biome), weight));
    }

    private static RegistryKey<Biome> key(Biome biome) {
        return RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)Objects.requireNonNull(ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome), "Biome registry name was null"));
    }
}

