/*
 * Decompiled with CFR 0.152.
 */
package com.nethersdelight.integration.jei;

import com.google.common.collect.ImmutableList;
import com.nethersdelight.core.registry.NDBlocks;
import com.nethersdelight.integration.jei.category.CompositionRecipeCategory;
import com.nethersdelight.integration.jei.resource.CompositionDummy;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("nethersdelight", "jei_plugin");
    private static final Minecraft MC = Minecraft.m_91087_();

    private static List<Recipe<?>> findRecipesByType(RecipeType<?> type) {
        return JEIPlugin.MC.f_91073_.m_7465_().m_44051_().stream().filter(r -> r.m_6671_() == type).collect(Collectors.toList());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new CompositionRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes((Collection)ImmutableList.of((Object)new CompositionDummy()), CompositionRecipeCategory.UID);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)NDBlocks.SOUL_COMPOST.get()), new ResourceLocation[]{CompositionRecipeCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)NDBlocks.BLACKSTONE_STOVE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.CAMPFIRE});
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

