/*
 * Decompiled with CFR 0.152.
 */
package com.hagenberg.fh.nomoretorchspam.common.block;

import com.hagenberg.fh.nomoretorchspam.NoMoreTorchSpam;
import com.hagenberg.fh.nomoretorchspam.common.block.GlowLight;
import com.hagenberg.fh.nomoretorchspam.config.Config;
import com.hagenberg.fh.nomoretorchspam.core.init.BlockInit;
import com.hagenberg.fh.nomoretorchspam.tileentity.GlowCrystalTileEntity;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class GlowCrystal
extends Block {
    protected static final VoxelShape ONE_AABB = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)10.0, (double)16.0, (double)10.0);
    protected static final VoxelShape TWO_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)5.0, (double)12.0, (double)16.0, (double)11.0);
    protected static final VoxelShape THREE_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)13.0, (double)16.0, (double)15.0);
    protected static final VoxelShape FOUR_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)2.0, (double)13.0, (double)16.0, (double)15.0);
    private final int HEIGHTDIFF = (Integer)Config.HEIGHTDIFF.get();
    private final int RADIUSDIFF = (Integer)Config.RADIUSDIFF.get();
    private final int AMOUNTOFDISCS = (Integer)Config.AMOUNTOFDISCS.get();
    private final int DISTANCE = (Integer)Config.DISTANCE.get();
    public static final IntegerProperty CRYSTALS = IntegerProperty.func_177719_a((String)"crystals", (int)1, (int)4);

    public GlowCrystal(AbstractBlock.Properties properties) {
        super(properties);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K) {
            ArrayList<BlockPos> positions = this.createGlowlights(world, pos, this.RADIUSDIFF * (Integer)state.func_177229_b((Property)CRYSTALS), this.AMOUNTOFDISCS);
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof GlowCrystalTileEntity) {
                GlowCrystalTileEntity GlowTE = (GlowCrystalTileEntity)te;
                GlowTE.setBlockPositions(positions);
                world.func_184138_a(pos, state, state, 2);
            }
        }
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof GlowCrystalTileEntity) {
            GlowCrystalTileEntity GlowTE = (GlowCrystalTileEntity)te;
            ArrayList<BlockPos> positions = GlowTE.getBlockPositions();
            this.destroyGlowlights(world, positions);
        }
        super.func_176208_a(world, pos, state, player);
    }

    private ArrayList<BlockPos> createGlowlights(World world, BlockPos center, int radius, int height) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int calcRadius = radius * radius + radius;
        for (int z = -radius; z <= radius; ++z) {
            for (int x = -radius; x <= radius; ++x) {
                int y;
                int n = y = center.func_177956_o() - this.HEIGHTDIFF < 0 ? 0 : -this.HEIGHTDIFF;
                while (y < height * this.HEIGHTDIFF) {
                    BlockPos pos;
                    if (x * x + z * z < calcRadius && z % this.DISTANCE == 0 && x % this.DISTANCE == 0 && world.func_180495_p(pos = new BlockPos(x + center.func_177958_n(), y + center.func_177956_o(), z + center.func_177952_p())).func_177230_c() instanceof AirBlock) {
                        world.func_241211_a_(pos, ((GlowLight)BlockInit.GLOW_LIGHT.get()).func_176223_P(), 3, 0);
                        positions.add(pos);
                    }
                    y += this.HEIGHTDIFF;
                }
            }
        }
        return positions;
    }

    private void destroyGlowlights(World world, ArrayList<BlockPos> positions) {
        if (positions == null || positions.size() == 0) {
            NoMoreTorchSpam.LOGGER.error("NO POSITIONS FOUND");
            return;
        }
        for (BlockPos pos : positions) {
            if (pos == null || !(world.func_180495_p(pos).func_177230_c() instanceof GlowLight)) continue;
            if (world.field_72995_K) {
                field_196273_d.info(pos.func_229422_x_());
            }
            world.func_241211_a_(pos, Blocks.field_150350_a.func_176223_P(), 3, 0);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{CRYSTALS});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new GlowCrystalTileEntity();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext selectionContext) {
        switch ((Integer)state.func_177229_b((Property)CRYSTALS)) {
            default: {
                return ONE_AABB;
            }
            case 2: {
                return TWO_AABB;
            }
            case 3: {
                return THREE_AABB;
            }
            case 4: 
        }
        return FOUR_AABB;
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext ctx) {
        if (ctx.func_195996_i().func_77973_b() == this.func_199767_j() && (Integer)state.func_177229_b((Property)CRYSTALS) < 4) {
            World world = ctx.func_195991_k();
            TileEntity te = world.func_175625_s(ctx.func_195995_a());
            if (te instanceof GlowCrystalTileEntity) {
                GlowCrystalTileEntity GlowTE = (GlowCrystalTileEntity)te;
                ArrayList<BlockPos> positions = GlowTE.getBlockPositions();
                this.destroyGlowlights(world, positions);
            }
            return true;
        }
        return super.func_196253_a(state, ctx);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState blockstate = ctx.func_195991_k().func_180495_p(ctx.func_195995_a());
        if (blockstate.func_203425_a((Block)this)) {
            return (BlockState)blockstate.func_206870_a((Property)CRYSTALS, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.func_177229_b((Property)CRYSTALS) + 1)));
        }
        return super.func_196258_a(ctx);
    }
}

