/*
 * Decompiled with CFR 0.152.
 */
package me.vital1ks.nongametime.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigManager {
    private static final double DEFAULT_X_POS = 10.0;
    private static final double DEFAULT_Y_POS = 10.0;
    private static final double DEFAULT_R = 255.0;
    private static final double DEFAULT_G = 255.0;
    private static final double DEFAULT_B = 255.0;
    private static final double DEFAULT_A = 255.0;
    private static final double DEFAULT_SCALE = 1.0;
    private static final boolean DEFAULT_SECONDS = false;
    private static final boolean DEFAULT_X_INV = false;
    private static final boolean DEFAULT_Y_INV = false;
    private static final ConfigManager INSTANCE;
    private static final ForgeConfigSpec SPEC;
    private static final Path CONFIG_PATH;
    private final ForgeConfigSpec.DoubleValue xPos;
    private final ForgeConfigSpec.DoubleValue yPos;
    private final ForgeConfigSpec.DoubleValue r;
    private final ForgeConfigSpec.DoubleValue g;
    private final ForgeConfigSpec.DoubleValue b;
    private final ForgeConfigSpec.DoubleValue a;
    private final ForgeConfigSpec.DoubleValue scale;
    private final ForgeConfigSpec.BooleanValue seconds;
    private final ForgeConfigSpec.BooleanValue xInv;
    private final ForgeConfigSpec.BooleanValue yInv;

    private ConfigManager(ForgeConfigSpec.Builder configSpecBuilder) {
        this.xPos = configSpecBuilder.translation("nongametime.configGui.posX.title").defineInRange("xPos", 10.0, 0.0, Double.MAX_VALUE);
        this.yPos = configSpecBuilder.translation("nongametime.configGui.posY.title").defineInRange("yPos", 10.0, 0.0, Double.MAX_VALUE);
        this.r = configSpecBuilder.translation("nongametime.configGui.r.title").defineInRange("r", 255.0, 0.0, 255.0);
        this.g = configSpecBuilder.translation("nongametime.configGui.g.title").defineInRange("g", 255.0, 0.0, 255.0);
        this.b = configSpecBuilder.translation("nongametime.configGui.b.title").defineInRange("b", 255.0, 0.0, 255.0);
        this.a = configSpecBuilder.translation("nongametime.configGui.a.title").defineInRange("a", 255.0, 0.0, 255.0);
        this.scale = configSpecBuilder.translation("nongametime.configGui.scale.title").defineInRange("scale", 1.0, 0.0, 25.0);
        this.seconds = configSpecBuilder.translation("nongametime.configGui.seconds.title").define("seconds", false);
        this.xInv = configSpecBuilder.translation("nongametime.configGui.xInv.title").define("xInv", false);
        this.yInv = configSpecBuilder.translation("nongametime.configGui.yInv.title").define("yInv", false);
    }

    public static ConfigManager getInstance() {
        return INSTANCE;
    }

    public int maxXPos() {
        return Minecraft.func_71410_x().func_228018_at_().func_198107_o();
    }

    public int maxYPos() {
        return Minecraft.func_71410_x().func_228018_at_().func_198087_p();
    }

    public int maxR() {
        return 255;
    }

    public int maxG() {
        return 255;
    }

    public int maxB() {
        return 255;
    }

    public int maxA() {
        return 255;
    }

    public int maxScale() {
        return 25;
    }

    public double xPos() {
        return (Double)this.xPos.get();
    }

    public double yPos() {
        return (Double)this.yPos.get();
    }

    public double r() {
        return (Double)this.r.get();
    }

    public double g() {
        return (Double)this.g.get();
    }

    public double b() {
        return (Double)this.b.get();
    }

    public double a() {
        return (Double)this.a.get();
    }

    public double scale() {
        return (Double)this.scale.get();
    }

    public boolean seconds() {
        return (Boolean)this.seconds.get();
    }

    public boolean xInv() {
        return (Boolean)this.xInv.get();
    }

    public boolean yInv() {
        return (Boolean)this.yInv.get();
    }

    public void changeXPos(double newValue) {
        double max = this.maxXPos();
        if (newValue < 0.0 || newValue > max) {
            throw new IllegalArgumentException("New value out of range  (0-" + max + "): " + newValue);
        }
        this.xPos.set((Object)newValue);
    }

    public void changeYPos(double newValue) {
        double max = this.maxYPos();
        if (newValue < 0.0 || newValue > max) {
            throw new IllegalArgumentException("New value out of range  (0-" + max + "): " + newValue);
        }
        this.yPos.set((Object)newValue);
    }

    public void changeR(double newValue) {
        int max = this.maxR();
        if (newValue < 0.0 || newValue > (double)max) {
            throw new IllegalArgumentException("New value out of range  (0-" + max + "): " + newValue);
        }
        this.r.set((Object)newValue);
    }

    public void changeG(double newValue) {
        int max = this.maxG();
        if (newValue < 0.0 || newValue > (double)max) {
            throw new IllegalArgumentException("New value out of range  (0-" + max + "): " + newValue);
        }
        this.g.set((Object)newValue);
    }

    public void changeB(double newValue) {
        int max = this.maxB();
        if (newValue < 0.0 || newValue > (double)max) {
            throw new IllegalArgumentException("New value out of range  (0-" + max + "): " + newValue);
        }
        this.b.set((Object)newValue);
    }

    public void changeA(double newValue) {
        int max = this.maxA();
        if (newValue < 0.0 || newValue > (double)max) {
            throw new IllegalArgumentException("New value out of range  (0-" + max + "): " + newValue);
        }
        this.a.set((Object)newValue);
    }

    public void changeScale(double newValue) {
        double max = this.maxScale();
        if (newValue < 0.0 || newValue > max) {
            throw new IllegalArgumentException("New value out of range  (0-" + max + "): " + newValue);
        }
        this.scale.set((Object)newValue);
    }

    public void changeSeconds(boolean newValue) {
        this.seconds.set((Object)newValue);
    }

    public void changeXInv(boolean newValue) {
        this.xInv.set((Object)newValue);
    }

    public void changeYInv(boolean newValue) {
        this.yInv.set((Object)newValue);
    }

    public void save() {
        SPEC.save();
    }

    static {
        CONFIG_PATH = Paths.get("config", "nongametime.toml");
        Pair specPair = new ForgeConfigSpec.Builder().configure(ConfigManager::new);
        INSTANCE = (ConfigManager)specPair.getLeft();
        SPEC = (ForgeConfigSpec)specPair.getRight();
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((Path)CONFIG_PATH).sync().autoreload().writingMode(WritingMode.REPLACE).build();
        config.load();
        config.save();
        SPEC.setConfig((CommentedConfig)config);
    }
}

