/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins;

import com.mojang.brigadier.CommandDispatcher;
import io.github.apace100.apoli.util.NamespaceAlias;
import io.github.apace100.calio.mixin.CriteriaRegistryInvoker;
import io.github.apace100.origins.command.LayerArgumentType;
import io.github.apace100.origins.command.OriginArgumentType;
import io.github.apace100.origins.command.OriginCommand;
import io.github.apace100.origins.networking.ModPacketsC2S;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginManager;
import io.github.apace100.origins.power.OriginsEntityConditions;
import io.github.apace100.origins.power.OriginsPowerTypes;
import io.github.apace100.origins.registry.ModBlocks;
import io.github.apace100.origins.registry.ModEnchantments;
import io.github.apace100.origins.registry.ModEntities;
import io.github.apace100.origins.registry.ModItems;
import io.github.apace100.origins.registry.ModLoot;
import io.github.apace100.origins.registry.ModTags;
import io.github.apace100.origins.util.ChoseOriginCriterion;
import io.github.apace100.origins.util.GainedPowerCriterion;
import io.github.apace100.origins.util.OriginsConfigSerializer;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_179;
import net.minecraft.class_2168;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import net.minecraft.class_2319;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Origins
implements ModInitializer {
    public static final String MODID = "origins";
    public static String VERSION = "";
    public static int[] SEMVER;
    public static final Logger LOGGER;
    public static ServerConfig config;

    public void onInitialize() {
        FabricLoader.getInstance().getModContainer(MODID).ifPresent(modContainer -> {
            VERSION = modContainer.getMetadata().getVersion().getFriendlyString();
            if (VERSION.contains("+")) {
                VERSION = VERSION.split("\\+")[0];
            }
            if (VERSION.contains("-")) {
                VERSION = VERSION.split("-")[0];
            }
            String[] splitVersion = VERSION.split("\\.");
            SEMVER = new int[splitVersion.length];
            for (int i = 0; i < SEMVER.length; ++i) {
                Origins.SEMVER[i] = Integer.parseInt(splitVersion[i]);
            }
        });
        LOGGER.info("Origins " + VERSION + " is initializing. Have fun!");
        AutoConfig.register(ServerConfig.class, OriginsConfigSerializer::new);
        config = (ServerConfig)AutoConfig.getConfigHolder(ServerConfig.class).getConfig();
        NamespaceAlias.addAlias((String)MODID, (String)"apoli");
        OriginsPowerTypes.register();
        OriginsEntityConditions.register();
        ModBlocks.register();
        ModItems.register();
        ModTags.register();
        ModPacketsC2S.register();
        ModEnchantments.register();
        ModEntities.register();
        ModLoot.registerLootTables();
        Origin.init();
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> OriginCommand.register((CommandDispatcher<class_2168>)dispatcher));
        CriteriaRegistryInvoker.callRegister((class_179)ChoseOriginCriterion.INSTANCE);
        CriteriaRegistryInvoker.callRegister((class_179)GainedPowerCriterion.INSTANCE);
        class_2316.method_10017((String)"origins:origin", OriginArgumentType.class, (class_2314)new class_2319(OriginArgumentType::origin));
        class_2316.method_10017((String)"origins:layer", LayerArgumentType.class, (class_2314)new class_2319(LayerArgumentType::layer));
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new OriginManager());
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new OriginLayers());
    }

    public static class_2960 identifier(String path) {
        return new class_2960(MODID, path);
    }

    static {
        LOGGER = LogManager.getLogger(Origins.class);
    }

    @Config(name="origins_server")
    public static class ServerConfig
    implements ConfigData {
        public boolean performVersionCheck = true;
    }
}

