/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.apace100.origins.command.LayerArgumentType;
import io.github.apace100.origins.command.OriginArgumentType;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.registry.ModComponents;
import java.util.Collection;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;

public class OriginCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"origin").requires(cs -> cs.method_9259(2))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"layer", (ArgumentType)LayerArgumentType.layer()).then(class_2170.method_9244((String)"origin", (ArgumentType)OriginArgumentType.origin()).executes(command -> {
            int i = 0;
            Collection targets = class_2186.method_9312((CommandContext)command, (String)"targets");
            OriginLayer l = LayerArgumentType.getLayer((CommandContext<class_2168>)command, "layer");
            Origin o = OriginArgumentType.getOrigin((CommandContext<class_2168>)command, "origin");
            for (class_3222 target : targets) {
                OriginCommand.setOrigin((class_1657)target, l, o);
                ++i;
            }
            if (targets.size() == 1) {
                ((class_2168)command.getSource()).method_9226((class_2561)new class_2588("commands.origin.set.success.single", new Object[]{((class_3222)targets.iterator().next()).method_5476(), new class_2588(l.getTranslationKey()), o.getName()}), true);
            } else {
                ((class_2168)command.getSource()).method_9226((class_2561)new class_2588("commands.origin.set.success.multiple", new Object[]{targets.size(), new class_2588(l.getTranslationKey()), o.getName()}), true);
            }
            return i;
        })))))).then(class_2170.method_9247((String)"has").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"layer", (ArgumentType)LayerArgumentType.layer()).then(class_2170.method_9244((String)"origin", (ArgumentType)OriginArgumentType.origin()).executes(command -> {
            int i = 0;
            Collection targets = class_2186.method_9312((CommandContext)command, (String)"targets");
            OriginLayer l = LayerArgumentType.getLayer((CommandContext<class_2168>)command, "layer");
            Origin o = OriginArgumentType.getOrigin((CommandContext<class_2168>)command, "origin");
            for (class_3222 target : targets) {
                if (!OriginCommand.hasOrigin((class_1657)target, l, o)) continue;
                ++i;
            }
            if (i == 0) {
                ((class_2168)command.getSource()).method_9213((class_2561)new class_2588("commands.execute.conditional.fail"));
            } else if (targets.size() == 1) {
                ((class_2168)command.getSource()).method_9226((class_2561)new class_2588("commands.execute.conditional.pass"), false);
            } else {
                ((class_2168)command.getSource()).method_9226((class_2561)new class_2588("commands.execute.conditional.pass_count", new Object[]{i}), false);
            }
            return i;
        })))))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"layer", (ArgumentType)LayerArgumentType.layer()).executes(command -> {
            class_3222 target = class_2186.method_9315((CommandContext)command, (String)"target");
            OriginLayer layer = LayerArgumentType.getLayer((CommandContext<class_2168>)command, "layer");
            OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)target);
            Origin origin = component.getOrigin(layer);
            ((class_2168)command.getSource()).method_9226((class_2561)new class_2588("commands.origin.get.result", new Object[]{target.method_5476(), new class_2588(layer.getTranslationKey()), origin.getName(), origin.getIdentifier()}), false);
            return 1;
        })))));
    }

    private static void setOrigin(class_1657 player, OriginLayer layer, Origin origin) {
        OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)player);
        component.setOrigin(layer, origin);
        OriginComponent.sync(player);
        boolean hadOriginBefore = component.hadOriginBefore();
        OriginComponent.onChosen(player, hadOriginBefore);
    }

    private static boolean hasOrigin(class_1657 player, OriginLayer layer, Origin origin) {
        OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)player);
        return component.hasOrigin(layer) && component.getOrigin(layer).equals(origin);
    }
}

