/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.component;

import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.ModifyPlayerSpawnPower;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.power.OriginsCallbackPower;
import io.github.apace100.origins.registry.ModComponents;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2960;

public interface OriginComponent
extends AutoSyncedComponent {
    public boolean hasOrigin(OriginLayer var1);

    public boolean hasAllOrigins();

    public HashMap<OriginLayer, Origin> getOrigins();

    public Origin getOrigin(OriginLayer var1);

    public boolean hadOriginBefore();

    public void setOrigin(OriginLayer var1, Origin var2);

    public void sync();

    public void onPowersRead();

    public static void sync(class_1657 player) {
        ModComponents.ORIGIN.sync((Object)player);
        PowerHolderComponent.KEY.sync((Object)player);
    }

    public static void onChosen(class_1657 player, boolean hadOriginBefore) {
        if (!hadOriginBefore) {
            PowerHolderComponent.getPowers((class_1297)player, ModifyPlayerSpawnPower.class).forEach(ModifyPlayerSpawnPower::teleportToModifiedSpawn);
        }
        PowerHolderComponent.getPowers((class_1297)player, OriginsCallbackPower.class).forEach(p -> p.onChosen(hadOriginBefore));
    }

    default public boolean checkAutoChoosingLayers(class_1657 player, boolean includeDefaults) {
        boolean choseOneAutomatically = false;
        ArrayList<OriginLayer> layers = new ArrayList<OriginLayer>();
        for (OriginLayer layer : OriginLayers.getLayers()) {
            if (!layer.isEnabled()) continue;
            layers.add(layer);
        }
        Collections.sort(layers);
        for (OriginLayer layer : layers) {
            boolean shouldContinue = false;
            if (layer.isEnabled() && !this.hasOrigin(layer)) {
                if (includeDefaults && layer.hasDefaultOrigin()) {
                    this.setOrigin(layer, OriginRegistry.get(layer.getDefaultOrigin()));
                    choseOneAutomatically = true;
                    shouldContinue = true;
                } else if (layer.getOriginOptionCount(player) == 1 && layer.shouldAutoChoose()) {
                    List origins = layer.getOrigins(player).stream().map(OriginRegistry::get).filter(Origin::isChoosable).collect(Collectors.toList());
                    if (origins.size() == 0) {
                        List<class_2960> randomOrigins = layer.getRandomOrigins(player);
                        this.setOrigin(layer, OriginRegistry.get(randomOrigins.get(player.method_6051().nextInt(randomOrigins.size()))));
                    } else {
                        this.setOrigin(layer, (Origin)origins.get(0));
                    }
                    choseOneAutomatically = true;
                    shouldContinue = true;
                } else if (layer.getOriginOptionCount(player) == 0) {
                    shouldContinue = true;
                }
            } else {
                shouldContinue = true;
            }
            if (shouldContinue) continue;
            break;
        }
        return choseOneAutomatically;
    }
}

