/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.power.factory.condition.ConditionTypes;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class OriginLayer
implements Comparable<OriginLayer> {
    private int order;
    private class_2960 identifier;
    private List<ConditionedOrigin> conditionedOrigins;
    private boolean enabled = false;
    private String nameTranslationKey;
    private String missingOriginNameTranslationKey;
    private String missingOriginDescriptionTranslationKey;
    private boolean isRandomAllowed = false;
    private boolean doesRandomAllowUnchoosable = false;
    private List<class_2960> originsExcludedFromRandom = null;
    private class_2960 defaultOrigin = null;
    private boolean autoChooseIfNoChoice = false;

    public String getOrCreateTranslationKey() {
        if (this.nameTranslationKey == null || this.nameTranslationKey.isEmpty()) {
            this.nameTranslationKey = "layer." + this.identifier.method_12836() + "." + this.identifier.method_12832() + ".name";
        }
        return this.nameTranslationKey;
    }

    public String getTranslationKey() {
        return this.getOrCreateTranslationKey();
    }

    public String getMissingOriginNameTranslationKey() {
        if (this.missingOriginNameTranslationKey == null || this.missingOriginNameTranslationKey.isEmpty()) {
            this.missingOriginNameTranslationKey = "layer." + this.identifier.method_12836() + "." + this.identifier.method_12832() + ".missing_origin.name";
        }
        return this.missingOriginNameTranslationKey;
    }

    public String getMissingOriginDescriptionTranslationKey() {
        if (this.missingOriginDescriptionTranslationKey == null || this.missingOriginDescriptionTranslationKey.isEmpty()) {
            this.missingOriginDescriptionTranslationKey = "layer." + this.identifier.method_12836() + "." + this.identifier.method_12832() + ".missing_origin.description";
        }
        return this.missingOriginDescriptionTranslationKey;
    }

    public class_2960 getIdentifier() {
        return this.identifier;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean hasDefaultOrigin() {
        return this.defaultOrigin != null;
    }

    public class_2960 getDefaultOrigin() {
        return this.defaultOrigin;
    }

    public boolean shouldAutoChoose() {
        return this.autoChooseIfNoChoice;
    }

    public List<class_2960> getOrigins() {
        return this.conditionedOrigins.stream().flatMap(co -> co.getOrigins().stream()).filter(OriginRegistry::contains).collect(Collectors.toList());
    }

    public List<class_2960> getOrigins(class_1657 playerEntity) {
        return this.conditionedOrigins.stream().filter(co -> co.isConditionFulfilled(playerEntity)).flatMap(co -> co.getOrigins().stream()).filter(OriginRegistry::contains).collect(Collectors.toList());
    }

    public int getOriginOptionCount(class_1657 playerEntity) {
        long choosableOrigins = this.getOrigins(playerEntity).stream().map(OriginRegistry::get).filter(Origin::isChoosable).count();
        if (this.isRandomAllowed && this.getRandomOrigins(playerEntity).size() > 0) {
            ++choosableOrigins;
        }
        return (int)choosableOrigins;
    }

    public boolean contains(Origin origin) {
        return this.conditionedOrigins.stream().anyMatch(co -> co.getOrigins().stream().anyMatch(o -> o.equals((Object)origin.getIdentifier())));
    }

    public boolean contains(Origin origin, class_1657 playerEntity) {
        return this.conditionedOrigins.stream().filter(co -> co.isConditionFulfilled(playerEntity)).anyMatch(co -> co.getOrigins().stream().anyMatch(o -> o.equals((Object)origin.getIdentifier())));
    }

    public boolean isRandomAllowed() {
        return this.isRandomAllowed;
    }

    public List<class_2960> getRandomOrigins(class_1657 playerEntity) {
        return this.conditionedOrigins.stream().filter(co -> co.isConditionFulfilled(playerEntity)).flatMap(co -> co.getOrigins().stream()).filter(OriginRegistry::contains).filter(o -> !this.originsExcludedFromRandom.contains(o)).filter(id -> this.doesRandomAllowUnchoosable || OriginRegistry.get(id).isChoosable()).collect(Collectors.toList());
    }

    public void merge(JsonObject json) {
        if (json.has("order")) {
            this.order = json.get("order").getAsInt();
        }
        if (json.has("enabled")) {
            this.enabled = json.get("enabled").getAsBoolean();
        }
        if (json.has("origins")) {
            JsonArray originArray = json.getAsJsonArray("origins");
            originArray.forEach(je -> this.conditionedOrigins.add(ConditionedOrigin.read(je)));
        }
        if (json.has("name")) {
            this.nameTranslationKey = class_3518.method_15253((JsonObject)json, (String)"name", (String)"");
        }
        if (json.has("missing_name")) {
            this.missingOriginNameTranslationKey = class_3518.method_15253((JsonObject)json, (String)"missing_name", (String)"");
        }
        if (json.has("missing_description")) {
            this.missingOriginDescriptionTranslationKey = class_3518.method_15253((JsonObject)json, (String)"missing_description", (String)"");
        }
        if (json.has("allow_random")) {
            this.isRandomAllowed = class_3518.method_15270((JsonObject)json, (String)"allow_random");
        }
        if (json.has("allow_random_unchoosable")) {
            this.doesRandomAllowUnchoosable = class_3518.method_15270((JsonObject)json, (String)"allow_random_unchoosable");
        }
        if (json.has("exclude_random") && json.get("exclude_random").isJsonArray()) {
            boolean replaceExclude = class_3518.method_15258((JsonObject)json, (String)"replace_exclude_random", (boolean)false);
            if (replaceExclude) {
                this.originsExcludedFromRandom.clear();
            }
            JsonArray excludeRandomArray = json.getAsJsonArray("exclude_random");
            excludeRandomArray.forEach(je -> this.originsExcludedFromRandom.add(class_2960.method_12829((String)je.getAsString())));
        }
        if (json.has("default_origin")) {
            this.defaultOrigin = new class_2960(class_3518.method_15265((JsonObject)json, (String)"default_origin"));
        }
        if (json.has("auto_choose")) {
            this.autoChooseIfNoChoice = class_3518.method_15270((JsonObject)json, (String)"auto_choose");
        }
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OriginLayer)) {
            return false;
        }
        return this.identifier.equals((Object)((OriginLayer)obj).identifier);
    }

    @Override
    public int compareTo(OriginLayer o) {
        return Integer.compare(this.order, o.order);
    }

    public void write(class_2540 buffer) {
        buffer.method_10814(this.identifier.toString());
        buffer.writeInt(this.order);
        buffer.writeBoolean(this.enabled);
        buffer.writeInt(this.conditionedOrigins.size());
        this.conditionedOrigins.forEach(co -> co.write(buffer));
        buffer.method_10814(this.getOrCreateTranslationKey());
        buffer.method_10814(this.getMissingOriginNameTranslationKey());
        buffer.method_10814(this.getMissingOriginDescriptionTranslationKey());
        buffer.writeBoolean(this.isRandomAllowed());
        if (this.isRandomAllowed()) {
            buffer.writeBoolean(this.doesRandomAllowUnchoosable);
            buffer.writeInt(this.originsExcludedFromRandom.size());
            this.originsExcludedFromRandom.forEach(arg_0 -> ((class_2540)buffer).method_10812(arg_0));
        }
        buffer.writeBoolean(this.hasDefaultOrigin());
        if (this.hasDefaultOrigin()) {
            buffer.method_10812(this.defaultOrigin);
        }
        buffer.writeBoolean(this.autoChooseIfNoChoice);
    }

    @Environment(value=EnvType.CLIENT)
    public static OriginLayer read(class_2540 buffer) {
        OriginLayer layer = new OriginLayer();
        layer.identifier = class_2960.method_12829((String)buffer.method_19772());
        layer.order = buffer.readInt();
        layer.enabled = buffer.readBoolean();
        int conditionedOriginCount = buffer.readInt();
        layer.conditionedOrigins = new ArrayList<ConditionedOrigin>(conditionedOriginCount);
        for (int i = 0; i < conditionedOriginCount; ++i) {
            layer.conditionedOrigins.add(ConditionedOrigin.read(buffer));
        }
        layer.nameTranslationKey = buffer.method_19772();
        layer.missingOriginNameTranslationKey = buffer.method_19772();
        layer.missingOriginDescriptionTranslationKey = buffer.method_19772();
        layer.isRandomAllowed = buffer.readBoolean();
        if (layer.isRandomAllowed) {
            layer.doesRandomAllowUnchoosable = buffer.readBoolean();
            int excludedSize = buffer.readInt();
            layer.originsExcludedFromRandom = new LinkedList<class_2960>();
            for (int i = 0; i < excludedSize; ++i) {
                layer.originsExcludedFromRandom.add(buffer.method_10810());
            }
        }
        if (buffer.readBoolean()) {
            layer.defaultOrigin = buffer.method_10810();
        }
        layer.autoChooseIfNoChoice = buffer.readBoolean();
        return layer;
    }

    public static OriginLayer fromJson(class_2960 id, JsonObject json) {
        int order = class_3518.method_15282((JsonObject)json, (String)"order", (int)OriginLayers.size());
        if (!json.has("origins") || !json.get("origins").isJsonArray()) {
            throw new JsonParseException("Origin layer JSON requires \"origins\" array of origin IDs to include in the layer.");
        }
        JsonArray originArray = json.getAsJsonArray("origins");
        ArrayList<ConditionedOrigin> list = new ArrayList<ConditionedOrigin>(originArray.size());
        originArray.forEach(je -> list.add(ConditionedOrigin.read(je)));
        boolean enabled = class_3518.method_15258((JsonObject)json, (String)"enabled", (boolean)true);
        OriginLayer layer = new OriginLayer();
        layer.order = order;
        layer.conditionedOrigins = list;
        layer.enabled = enabled;
        layer.identifier = id;
        layer.nameTranslationKey = class_3518.method_15253((JsonObject)json, (String)"name", (String)"");
        layer.missingOriginNameTranslationKey = class_3518.method_15253((JsonObject)json, (String)"missing_name", (String)"");
        layer.missingOriginDescriptionTranslationKey = class_3518.method_15253((JsonObject)json, (String)"missing_description", (String)"");
        layer.isRandomAllowed = class_3518.method_15258((JsonObject)json, (String)"allow_random", (boolean)false);
        layer.doesRandomAllowUnchoosable = class_3518.method_15258((JsonObject)json, (String)"allow_random_unchoosable", (boolean)false);
        layer.originsExcludedFromRandom = new LinkedList<class_2960>();
        if (json.has("exclude_random") && json.get("exclude_random").isJsonArray()) {
            JsonArray excludeRandomArray = json.getAsJsonArray("exclude_random");
            excludeRandomArray.forEach(je -> layer.originsExcludedFromRandom.add(class_2960.method_12829((String)je.getAsString())));
        }
        if (json.has("default_origin")) {
            layer.defaultOrigin = new class_2960(class_3518.method_15265((JsonObject)json, (String)"default_origin"));
        }
        layer.autoChooseIfNoChoice = class_3518.method_15258((JsonObject)json, (String)"auto_choose", (boolean)false);
        return layer;
    }

    public static class ConditionedOrigin {
        private final ConditionFactory.Instance condition;
        private final List<class_2960> origins;
        private static final SerializableData conditionedOriginObjectData = new SerializableData().add("condition", ApoliDataTypes.ENTITY_CONDITION).add("origins", SerializableDataTypes.IDENTIFIERS);

        public ConditionedOrigin(ConditionFactory.Instance condition, List<class_2960> origins) {
            this.condition = condition;
            this.origins = origins;
        }

        public boolean isConditionFulfilled(class_1657 playerEntity) {
            return this.condition == null || this.condition.test((Object)playerEntity);
        }

        public List<class_2960> getOrigins() {
            return this.origins;
        }

        public void write(class_2540 buffer) {
            buffer.writeBoolean(this.condition != null);
            if (this.condition != null) {
                this.condition.write(buffer);
            }
            buffer.writeInt(this.origins.size());
            this.origins.forEach(arg_0 -> ((class_2540)buffer).method_10812(arg_0));
        }

        @Environment(value=EnvType.CLIENT)
        public static ConditionedOrigin read(class_2540 buffer) {
            ConditionFactory.Instance condition = null;
            if (buffer.readBoolean()) {
                condition = ConditionTypes.ENTITY.read(buffer);
            }
            int originCount = buffer.readInt();
            ArrayList<class_2960> originList = new ArrayList<class_2960>(originCount);
            for (int i = 0; i < originCount; ++i) {
                originList.add(buffer.method_10810());
            }
            return new ConditionedOrigin(condition, originList);
        }

        public static ConditionedOrigin read(JsonElement element) {
            if (element.isJsonPrimitive()) {
                JsonPrimitive elemPrimitive = element.getAsJsonPrimitive();
                if (elemPrimitive.isString()) {
                    return new ConditionedOrigin(null, Lists.newArrayList((Object[])new class_2960[]{class_2960.method_12829((String)elemPrimitive.getAsString())}));
                }
                throw new JsonParseException("Expected origin in layer to be either a string or an object.");
            }
            if (element.isJsonObject()) {
                SerializableData.Instance data = conditionedOriginObjectData.read(element.getAsJsonObject());
                return new ConditionedOrigin((ConditionFactory.Instance)data.get("condition"), (List)data.get("origins"));
            }
            throw new JsonParseException("Expected origin in layer to be either a string or an object.");
        }
    }
}

