/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.origins.OriginsClient;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.registry.ModComponents;
import io.github.apace100.origins.screen.ChooseOriginScreen;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_746;

public class ViewOriginScreen
extends class_437 {
    private static final class_2960 WINDOW = new class_2960("origins", "textures/gui/choose_origin.png");
    private ArrayList<class_3545<OriginLayer, Origin>> originLayers;
    private int currentLayer = 0;
    private static final int windowWidth = 176;
    private static final int windowHeight = 182;
    private int scrollPos = 0;
    private int currentMaxScroll = 0;
    private int border = 13;
    private class_4185 chooseOriginButton;
    private int guiTop;
    private int guiLeft;

    public ViewOriginScreen() {
        super((class_2561)new class_2588("origins.screen.view_origin"));
        HashMap<OriginLayer, Origin> origins = ((OriginComponent)ModComponents.ORIGIN.get((Object)class_310.method_1551().field_1724)).getOrigins();
        this.originLayers = new ArrayList(origins.size());
        class_746 player = class_310.method_1551().field_1724;
        origins.forEach((arg_0, arg_1) -> this.lambda$new$0((class_1657)player, arg_0, arg_1));
        this.originLayers.sort(Comparator.comparing(class_3545::method_15442));
    }

    public boolean method_25422() {
        return true;
    }

    protected void method_25426() {
        super.method_25426();
        this.guiLeft = (this.field_22789 - 176) / 2;
        this.guiTop = (this.field_22790 - 182) / 2;
        if (this.originLayers.size() > 0 && OriginsClient.isServerRunningOrigins) {
            this.chooseOriginButton = new class_4185(this.guiLeft + 88 - 50, this.guiTop + 182 - 40, 100, 20, (class_2561)new class_2588("origins.gui.choose"), b -> class_310.method_1551().method_1507((class_437)new ChooseOriginScreen(Lists.newArrayList((Object[])new OriginLayer[]{(OriginLayer)this.originLayers.get(this.currentLayer).method_15442()}), 0, false)));
            this.method_37063((class_364)this.chooseOriginButton);
            class_746 player = class_310.method_1551().field_1724;
            this.chooseOriginButton.field_22764 = this.originLayers.get(this.currentLayer).method_15441() == Origin.EMPTY && ((OriginLayer)this.originLayers.get(this.currentLayer).method_15442()).getOriginOptionCount((class_1657)player) > 0;
            this.chooseOriginButton.field_22763 = this.chooseOriginButton.field_22764;
            this.method_37063((class_364)new class_4185(this.guiLeft - 40, this.field_22790 / 2 - 10, 20, 20, (class_2561)new class_2585("<"), arg_0 -> this.lambda$init$2((class_1657)player, arg_0)));
            this.method_37063((class_364)new class_4185(this.guiLeft + 176 + 20, this.field_22790 / 2 - 10, 20, 20, (class_2561)new class_2585(">"), arg_0 -> this.lambda$init$3((class_1657)player, arg_0)));
        }
        this.method_37063((class_364)new class_4185(this.guiLeft + 88 - 50, this.guiTop + 182 + 5, 100, 20, (class_2561)new class_2588("origins.gui.close"), b -> class_310.method_1551().method_1507(null)));
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        this.renderOriginWindow(matrices, mouseX, mouseY);
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    private void renderOriginWindow(class_4587 matrices, int mouseX, int mouseY) {
        boolean hasLayer;
        RenderSystem.enableBlend();
        boolean bl = hasLayer = this.originLayers.size() > 0;
        if (hasLayer && OriginsClient.isServerRunningOrigins) {
            this.renderWindowBackground(matrices, 16, 0);
            this.renderOriginContent(matrices, mouseX, mouseY);
            RenderSystem.setShaderTexture((int)0, (class_2960)WINDOW);
            this.method_25302(matrices, this.guiLeft, this.guiTop, 0, 0, 176, 182);
            this.renderOriginName(matrices);
            RenderSystem.setShaderTexture((int)0, (class_2960)WINDOW);
            this.renderOriginImpact(matrices, mouseX, mouseY);
            class_2588 title = new class_2588("origins.gui.view_origin.title", new Object[]{new class_2588(((OriginLayer)this.originLayers.get(this.currentLayer).method_15442()).getTranslationKey())});
            ViewOriginScreen.method_25300((class_4587)matrices, (class_327)this.field_22793, (String)title.getString(), (int)(this.field_22789 / 2), (int)(this.guiTop - 15), (int)0xFFFFFF);
        } else if (OriginsClient.isServerRunningOrigins) {
            ViewOriginScreen.method_25300((class_4587)matrices, (class_327)this.field_22793, (String)new class_2588("origins.gui.view_origin.empty").getString(), (int)(this.field_22789 / 2), (int)(this.guiTop + 15), (int)0xFFFFFF);
        } else {
            ViewOriginScreen.method_25300((class_4587)matrices, (class_327)this.field_22793, (String)new class_2588("origins.gui.view_origin.not_installed").getString(), (int)(this.field_22789 / 2), (int)(this.guiTop + 15), (int)0xFFFFFF);
        }
        RenderSystem.disableBlend();
    }

    private Origin getCurrentOrigin() {
        return (Origin)this.originLayers.get(this.currentLayer).method_15441();
    }

    private void renderOriginImpact(class_4587 matrices, int mouseX, int mouseY) {
        Impact impact = this.getCurrentOrigin().getImpact();
        int impactValue = impact.getImpactValue();
        int wOffset = impactValue * 8;
        for (int i = 0; i < 3; ++i) {
            if (i < impactValue) {
                this.method_25302(matrices, this.guiLeft + 128 + i * 10, this.guiTop + 19, 176 + wOffset, 16, 8, 8);
                continue;
            }
            this.method_25302(matrices, this.guiLeft + 128 + i * 10, this.guiTop + 19, 176, 16, 8, 8);
        }
        if (mouseX >= this.guiLeft + 128 && mouseX <= this.guiLeft + 158 && mouseY >= this.guiTop + 19 && mouseY <= this.guiTop + 27) {
            class_2588 ttc = (class_2588)new class_2588("origins.gui.impact.impact").method_27693(": ").method_10852((class_2561)impact.getTextComponent());
            this.method_25424(matrices, (class_2561)ttc, mouseX, mouseY);
        }
    }

    private void renderOriginName(class_4587 matrices) {
        Origin origin = this.getCurrentOrigin();
        class_5348 originName = this.field_22793.method_1714((class_5348)(origin == Origin.EMPTY ? new class_2588(((OriginLayer)this.originLayers.get(this.currentLayer).method_15442()).getMissingOriginNameTranslationKey()) : origin.getName()), 140);
        ViewOriginScreen.method_25303((class_4587)matrices, (class_327)this.field_22793, (String)originName.getString(), (int)(this.guiLeft + 39), (int)(this.guiTop + 19), (int)0xFFFFFF);
        class_1799 is = origin.getDisplayItem();
        this.field_22788.method_27953(is, this.guiLeft + 15, this.guiTop + 15);
    }

    private void renderWindowBackground(class_4587 matrices, int offsetYStart, int offsetYEnd) {
        int endX = this.guiLeft + 176 - this.border;
        int endY = this.guiTop + 182 - this.border;
        RenderSystem.setShaderTexture((int)0, (class_2960)WINDOW);
        for (int x = this.guiLeft; x < endX; x += 16) {
            for (int y = this.guiTop + offsetYStart; y < endY + offsetYEnd; y += 16) {
                this.method_25302(matrices, x, y, 176, 0, Math.max(16, endX - x), Math.max(16, endY + offsetYEnd - y));
            }
        }
    }

    public boolean method_25401(double x, double y, double z) {
        boolean retValue = super.method_25401(x, y, z);
        int np = this.scrollPos - (int)z * 4;
        this.scrollPos = np < 0 ? 0 : Math.min(np, this.currentMaxScroll);
        return retValue;
    }

    private void renderOriginContent(class_4587 matrices, int mouseX, int mouseY) {
        int y;
        int x = this.guiLeft + 18;
        int startY = y = this.guiTop + 50;
        int endY = y - 72 + 182;
        y -= this.scrollPos;
        Origin origin = this.getCurrentOrigin();
        class_2588 orgDesc = origin.getDescription();
        if (origin == Origin.EMPTY) {
            orgDesc = new class_2588(((OriginLayer)this.originLayers.get(this.currentLayer).method_15442()).getMissingOriginDescriptionTranslationKey());
        }
        List descLines = this.field_22793.method_1728((class_5348)orgDesc, 140);
        for (class_5481 class_54812 : descLines) {
            if (y >= startY - 18 && y <= endY + 12) {
                this.field_22793.method_27528(matrices, class_54812, (float)(x + 2), (float)(y - 6), 0xCCCCCC);
            }
            y += 12;
        }
        if (origin == Origin.EMPTY) {
            return;
        }
        for (PowerType powerType : origin.getPowerTypes()) {
            if (powerType.isHidden()) continue;
            class_5481 name = class_2477.method_10517().method_30934(this.field_22793.method_1714((class_5348)powerType.getName().method_27692(class_124.field_1073), 140));
            class_2588 desc = powerType.getDescription();
            List drawLines = this.field_22793.method_1728((class_5348)desc, 140);
            if (y >= startY - 24 && y <= endY + 12) {
                this.field_22793.method_27528(matrices, name, (float)x, (float)y, 0xFFFFFF);
            }
            for (class_5481 line : drawLines) {
                if ((y += 12) < startY - 24 || y > endY + 12) continue;
                this.field_22793.method_27528(matrices, line, (float)(x + 2), (float)y, 0xCCCCCC);
            }
            y += 14;
        }
        this.currentMaxScroll = (y += this.scrollPos) - 182 - 15;
        if (this.currentMaxScroll < 0) {
            this.currentMaxScroll = 0;
        }
    }

    private /* synthetic */ void lambda$init$3(class_1657 player, class_4185 b) {
        this.currentLayer = (this.currentLayer + 1) % this.originLayers.size();
        this.chooseOriginButton.field_22764 = this.originLayers.get(this.currentLayer).method_15441() == Origin.EMPTY && ((OriginLayer)this.originLayers.get(this.currentLayer).method_15442()).getOriginOptionCount(player) > 0;
        this.chooseOriginButton.field_22763 = this.chooseOriginButton.field_22764;
        this.scrollPos = 0;
    }

    private /* synthetic */ void lambda$init$2(class_1657 player, class_4185 b) {
        this.currentLayer = (this.currentLayer - 1 + this.originLayers.size()) % this.originLayers.size();
        this.chooseOriginButton.field_22764 = this.originLayers.get(this.currentLayer).method_15441() == Origin.EMPTY && ((OriginLayer)this.originLayers.get(this.currentLayer).method_15442()).getOriginOptionCount(player) > 0;
        this.chooseOriginButton.field_22763 = this.chooseOriginButton.field_22764;
        this.scrollPos = 0;
    }

    private /* synthetic */ void lambda$new$0(class_1657 player, OriginLayer layer, Origin origin) {
        if (origin.getDisplayItem().method_7909() == class_1802.field_8575) {
            origin.getDisplayItem().method_7948().method_10582("SkullOwner", player.method_5476().getString());
        }
        if (origin != Origin.EMPTY || layer.getOriginOptionCount(player) > 0) {
            this.originLayers.add((class_3545<OriginLayer, Origin>)new class_3545((Object)layer, (Object)origin));
        }
    }
}

