/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.overworld_mirror.config;

import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.Config;

@Config(modid="overworldmirror", category="")
public class CommonConfig {
    public static Settings settings = new Settings();

    public static class Settings {
        @Config.RequiresMcRestart
        @Config.Comment(value={"The Dimension ID to avoid conflicts with other mods"})
        @Config.Name(value="Dimension ID")
        public int dimension_id = DimensionManager.getNextFreeDimId();
        @Config.Comment(value={"The worldtype of the mirrored world"})
        @Config.Name(value="World Type")
        public String world_type = "default";
        @Config.Comment(value={"The generator settings of the mirrored world"})
        @Config.Name(value="Generator Settings")
        public String generator_settings = "";
        @Config.Comment(value={"If you want a completly mirrored world, you need to set this to 0"})
        @Config.Name(value="Seed Shift")
        public int seed_shift = 100000;
        @Config.Comment(value={"Set this if you want to have a higher movement factor like the nether has 8"})
        @Config.Name(value="Movement Factor")
        @Config.RangeDouble(min=0.0, max=2.147483647E9)
        public double movement_factor = 1.0;
        @Config.Comment(value={"How many blocks the portal can be from the normal spawn location to not create a new one. The value is not in sqrt cause of lag reduction. 400 = 20 Blocks, 900 = 30 Blocks, etc"})
        @Config.Name(value="Portal Distance")
        @Config.RangeDouble(min=1.0, max=1.0E20)
        public double portal_distance = 400.0;
        @Config.Comment(value={"Some mods only use the dimension id to generate their ores and structure in the world. This calls the generator an other time with the dimension id set to 0 (overworld) to generate all stuff. ATTENTION: This might generate way to many ores because mods that only check the world provider may generate twice! Use with caution!"})
        @Config.Name(value="Enable Generation Hackery")
        public boolean enable_generation_hackery = false;
    }
}

