/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.overworld_mirror.portal;

import info.u_team.overworld_mirror.config.CommonConfig;
import info.u_team.overworld_mirror.init.OverworldMirrorBlocks;
import info.u_team.overworld_mirror.portal.WorldSaveDataPortal;
import java.util.ArrayList;
import java.util.ListIterator;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class PortalManager {
    public static boolean trySpawnPortalFromFrame(World world, BlockPos pos) {
        int north_count;
        int west_count;
        for (west_count = 0; world.func_180495_p(pos.func_177985_f(west_count + 1)).func_177230_c() != Blocks.field_150417_aV && west_count < 3; ++west_count) {
        }
        BlockPos west_pos = pos.func_177985_f(west_count);
        for (north_count = 0; world.func_180495_p(west_pos.func_177964_d(north_count + 1)).func_177230_c() != Blocks.field_150417_aV && north_count < 3; ++north_count) {
        }
        BlockPos west_north_pos = west_pos.func_177964_d(north_count);
        BlockPos middle_pos = west_north_pos.func_177974_f().func_177968_d();
        if (!PortalManager.validatePortalFrameAndSpawnPortal(world, middle_pos)) {
            return false;
        }
        WorldSaveDataPortal data = PortalManager.getSaveData(world);
        data.getPortals().add(middle_pos);
        data.func_76185_a();
        return true;
    }

    private static boolean validatePortalFrameAndSpawnPortal(World world, BlockPos pos) {
        int i;
        ArrayList<BlockPos> flowers = new ArrayList<BlockPos>();
        ArrayList<BlockPos> frame = new ArrayList<BlockPos>();
        for (i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                flowers.add(pos.func_177982_a(i, 0, j));
            }
        }
        for (i = -1; i <= 1; ++i) {
            frame.add(pos.func_177982_a(2, 0, i));
            frame.add(pos.func_177982_a(-2, 0, i));
            frame.add(pos.func_177982_a(i, 0, 2));
            frame.add(pos.func_177982_a(i, 0, -2));
        }
        boolean flowers_ok = flowers.stream().allMatch(flower_pos -> world.func_180495_p(flower_pos).func_177230_c() instanceof BlockFlower);
        boolean frame_ok = frame.stream().allMatch(frame_pos -> world.func_180495_p(frame_pos).func_177230_c() == Blocks.field_150417_aV);
        if (flowers_ok && frame_ok) {
            flowers.forEach(portal_pos -> world.func_180501_a(portal_pos, OverworldMirrorBlocks.portal.func_176223_P(), 2));
            PlayerList playerlist = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
            flowers.forEach(portal_pos -> playerlist.func_148543_a(null, (double)portal_pos.func_177958_n(), (double)portal_pos.func_177956_o(), (double)portal_pos.func_177952_p(), 64.0, world.field_73011_w.getDimension(), (Packet)new SPacketBlockChange(world, portal_pos)));
            return true;
        }
        return false;
    }

    public static void trySummonEntityInPortal(World world, Entity entity, float yaw) {
        BlockPos entity_pos = entity.func_180425_c();
        WorldSaveDataPortal data = PortalManager.getSaveData(world);
        BlockPos middle_pos = null;
        ListIterator<BlockPos> iterator = data.getPortals().listIterator();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            if (!(PortalManager.distanceSq(pos.func_177958_n(), pos.func_177952_p(), entity_pos.func_177958_n(), entity_pos.func_177952_p()) < CommonConfig.settings.portal_distance)) continue;
            if (PortalManager.validatePortal(world, pos)) {
                middle_pos = pos;
                break;
            }
            iterator.remove();
            data.func_76185_a();
        }
        if (middle_pos == null) {
            middle_pos = PortalManager.spawnPortal(world, entity_pos);
            data.getPortals().add(middle_pos);
            data.func_76185_a();
        }
        entity.func_70080_a((double)middle_pos.func_177958_n() + 0.5, (double)middle_pos.func_177956_o(), (double)((float)middle_pos.func_177952_p() + 0.5f), yaw, entity.field_70125_A);
    }

    private static boolean validatePortal(World world, BlockPos pos) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (world.func_180495_p(pos.func_177982_a(i, 0, j)).func_177230_c() == OverworldMirrorBlocks.portal) continue;
                return false;
            }
        }
        return true;
    }

    private static BlockPos spawnPortal(World world, BlockPos entity_pos) {
        int i;
        BlockPos pos = world.func_175725_q(entity_pos).func_177977_b();
        ArrayList<BlockPos> portal = new ArrayList<BlockPos>();
        ArrayList<BlockPos> frame = new ArrayList<BlockPos>();
        for (i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                portal.add(pos.func_177982_a(i, 0, j));
            }
        }
        for (i = -2; i <= 2; ++i) {
            frame.add(pos.func_177982_a(2, 0, i));
            frame.add(pos.func_177982_a(-2, 0, i));
            frame.add(pos.func_177982_a(i, 0, 2));
            frame.add(pos.func_177982_a(i, 0, -2));
        }
        frame.forEach(frame_pos -> {
            world.func_175656_a(frame_pos, Blocks.field_150417_aV.func_176223_P());
            world.func_175698_g(frame_pos.func_177984_a());
            world.func_175698_g(frame_pos.func_177981_b(2));
        });
        portal.forEach(portal_pos -> {
            world.func_175656_a(portal_pos.func_177977_b(), Blocks.field_150417_aV.func_176223_P());
            world.func_180501_a(portal_pos, OverworldMirrorBlocks.portal.func_176223_P(), 2);
        });
        return pos;
    }

    public static WorldSaveDataPortal getSaveData(World world) {
        MapStorage storage = world.getPerWorldStorage();
        WorldSaveDataPortal instance = (WorldSaveDataPortal)storage.func_75742_a(WorldSaveDataPortal.class, "overworldmirror_portal");
        if (instance == null) {
            instance = new WorldSaveDataPortal("overworldmirror_portal");
            storage.func_75745_a("overworldmirror_portal", (WorldSavedData)instance);
        }
        return instance;
    }

    public static double distanceSq(double from_x, double from_z, double to_x, double to_z) {
        double x = from_x - to_x;
        double z = from_z - to_z;
        return x * x + z * z;
    }
}

