/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.overworld_mirror.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class CommonConfig {
    public static final ForgeConfigSpec config;
    private static final CommonConfig instance;
    public final ForgeConfigSpec.EnumValue<SeedType> seedType;
    public final ForgeConfigSpec.LongValue seedValue;
    public final ForgeConfigSpec.ConfigValue<String> generatorType;
    public final ForgeConfigSpec.ConfigValue<String> generatorSettings;
    public final ForgeConfigSpec.DoubleValue movementFactor;
    public final ForgeConfigSpec.DoubleValue portalDistance;

    public static CommonConfig getInstance() {
        return instance;
    }

    private CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Seed settings").push("seed");
        this.seedType = builder.comment("If you have set this to \"SEED\" then the seedValue value will be treated as new seed, else if its set to \"ADDITION\" the value will be added to the main world seed.").defineEnum("seedType", (Enum)SeedType.ADDITION);
        this.seedValue = builder.comment("The seed value. See seedType for more information.").defineInRange("seedValue", 100000L, Long.MIN_VALUE, Long.MAX_VALUE);
        builder.pop();
        builder.comment("Generation settings").push("generator");
        this.generatorType = builder.comment("Generator type e.g. default, flat, buffet, ...").define("generatorType", (Object)"default");
        this.generatorSettings = builder.comment("Generator settings for flat and buffet. Attention, the format has changed in 1.13!").define("generatorSettings", (Object)"");
        builder.pop();
        builder.comment("Portal settings").push("portal");
        this.movementFactor = builder.comment("Movement factor. Like in the nether you move 8 times the block length as in the overworld").defineInRange("movementFactor", 1.0, 0.0, 1.0E10);
        this.portalDistance = builder.comment("How many blocks the portal can be from the normal spawn location to not create a new one. The value is not in sqrt cause of lag reduction. 400 = 20 Blocks, 900 = 30 Blocks, etc").defineInRange("portalDistance", 400.0, 1.0, 1.0E20);
        builder.pop();
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        config = (ForgeConfigSpec)pair.getRight();
        instance = (CommonConfig)pair.getLeft();
    }

    public static enum SeedType {
        SEED,
        ADDITION;


        public long calculateSeed(long seedValue, long worldSeed) {
            if (this == SEED) {
                return seedValue;
            }
            return worldSeed + seedValue;
        }
    }
}

