/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.overworld_mirror.dimension;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import info.u_team.overworld_mirror.config.CommonConfig;
import info.u_team.overworld_mirror.dimension.SeedFixWorldInfo;
import info.u_team.overworld_mirror.dimension.WorldSaveDataDimension;
import info.u_team.u_team_core.util.world.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.biome.provider.CheckerboardBiomeProviderSettings;
import net.minecraft.world.biome.provider.IBiomeProviderSettings;
import net.minecraft.world.biome.provider.OverworldBiomeProviderSettings;
import net.minecraft.world.biome.provider.SingleBiomeProviderSettings;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.dimension.OverworldDimension;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.EndGenSettings;
import net.minecraft.world.gen.FlatGenSettings;
import net.minecraft.world.gen.IChunkGenSettings;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NetherGenSettings;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.storage.WorldInfo;

public class DimensionOverworldMirror
extends OverworldDimension {
    private WorldSaveDataDimension saveData;
    private CommonConfig config;

    public DimensionOverworldMirror(DimensionType type) {
        super(type);
    }

    protected void func_76572_b() {
        super.func_76572_b();
        this.saveData = this.getSaveData();
        this.config = CommonConfig.getInstance();
    }

    public boolean func_186056_c(int x, int z) {
        return false;
    }

    public void setWorldTime(long time) {
        this.saveData.setTime(time);
    }

    public long getWorldTime() {
        return this.saveData.getTime();
    }

    public long getSeed() {
        return ((CommonConfig.SeedType)((Object)this.config.seedType.get())).calculateSeed((Long)this.config.seedValue.get(), super.getSeed());
    }

    public double getMovementFactor() {
        return (Double)this.config.movementFactor.get();
    }

    public IChunkGenerator<? extends IChunkGenSettings> func_186060_c() {
        NBTTagCompound generationOptions;
        WorldType worldtype = WorldType.func_77130_a((String)((String)this.config.generatorType.get()));
        if (worldtype == null) {
            worldtype = WorldType.field_77137_b;
        }
        String configGeneratorOptionsString = (String)this.config.generatorSettings.get();
        JsonObject configGeneratorOptionsJson = new JsonObject();
        if (!configGeneratorOptionsString.isEmpty()) {
            configGeneratorOptionsJson = JsonUtils.func_212746_a((String)configGeneratorOptionsString, (boolean)true);
        }
        if ((generationOptions = (NBTTagCompound)Dynamic.convert((DynamicOps)JsonOps.INSTANCE, (DynamicOps)NBTDynamicOps.field_210820_a, (Object)configGeneratorOptionsJson)) == null) {
            generationOptions = new NBTTagCompound();
        }
        ChunkGeneratorType flatChunkGenerator = ChunkGeneratorType.field_205489_f;
        ChunkGeneratorType debugChunkGenerator = ChunkGeneratorType.field_205488_e;
        ChunkGeneratorType cavesChunkGenerator = ChunkGeneratorType.field_206912_c;
        ChunkGeneratorType floatingIslandsChunkGenerator = ChunkGeneratorType.field_206913_d;
        ChunkGeneratorType surfaceChunkGenerator = ChunkGeneratorType.field_206911_b;
        BiomeProviderType fixedBiomeProvider = BiomeProviderType.field_205461_c;
        BiomeProviderType vanillaLayeredBiomeProvider = BiomeProviderType.field_206859_d;
        BiomeProviderType checkerBoardBiomeProvider = BiomeProviderType.field_205460_b;
        if (worldtype == WorldType.field_77138_c) {
            FlatGenSettings flatgensettings = FlatGenSettings.func_210835_a((Dynamic)new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)generationOptions));
            SingleBiomeProviderSettings singlebiomeprovidersettings1 = ((SingleBiomeProviderSettings)fixedBiomeProvider.func_205458_a()).func_205436_a(flatgensettings.func_82648_a());
            return flatChunkGenerator.create(this.field_76579_a, fixedBiomeProvider.func_205457_a((IBiomeProviderSettings)singlebiomeprovidersettings1), (IChunkGenSettings)flatgensettings);
        }
        if (worldtype == WorldType.field_180272_g) {
            SingleBiomeProviderSettings singlebiomeprovidersettings = ((SingleBiomeProviderSettings)fixedBiomeProvider.func_205458_a()).func_205436_a(Biomes.field_76772_c);
            return debugChunkGenerator.create(this.field_76579_a, fixedBiomeProvider.func_205457_a((IBiomeProviderSettings)singlebiomeprovidersettings), debugChunkGenerator.func_205483_a());
        }
        if (worldtype != WorldType.field_205394_h) {
            OverworldGenSettings overworldgensettings = (OverworldGenSettings)surfaceChunkGenerator.func_205483_a();
            OverworldBiomeProviderSettings overworldbiomeprovidersettings = ((OverworldBiomeProviderSettings)vanillaLayeredBiomeProvider.func_205458_a()).func_205439_a((WorldInfo)new SeedFixWorldInfo(this.field_76579_a.func_72912_H())).func_205441_a(overworldgensettings);
            return surfaceChunkGenerator.create(this.field_76579_a, vanillaLayeredBiomeProvider.func_205457_a((IBiomeProviderSettings)overworldbiomeprovidersettings), (IChunkGenSettings)overworldgensettings);
        }
        BiomeProvider biomeprovider = null;
        JsonElement jsonelement = (JsonElement)Dynamic.convert((DynamicOps)NBTDynamicOps.field_210820_a, (DynamicOps)JsonOps.INSTANCE, (Object)generationOptions);
        JsonObject jsonobject = jsonelement.getAsJsonObject();
        if (jsonobject.has("biome_source") && jsonobject.getAsJsonObject("biome_source").has("type") && jsonobject.getAsJsonObject("biome_source").has("options")) {
            ResourceLocation resourcelocation = new ResourceLocation(jsonobject.getAsJsonObject("biome_source").getAsJsonPrimitive("type").getAsString());
            JsonObject jsonobject1 = jsonobject.getAsJsonObject("biome_source").getAsJsonObject("options");
            Biome[] abiome = new Biome[]{Biomes.field_76771_b};
            if (jsonobject1.has("biomes")) {
                Biome[] biomeArray;
                JsonArray jsonarray = jsonobject1.getAsJsonArray("biomes");
                if (jsonarray.size() > 0) {
                    biomeArray = new Biome[jsonarray.size()];
                } else {
                    Biome[] biomeArray2 = new Biome[1];
                    biomeArray = biomeArray2;
                    biomeArray2[0] = Biomes.field_76771_b;
                }
                abiome = biomeArray;
                for (int i = 0; i < jsonarray.size(); ++i) {
                    Biome biome = (Biome)IRegistry.field_212624_m.func_212608_b(new ResourceLocation(jsonarray.get(i).getAsString()));
                    abiome[i] = biome != null ? biome : Biomes.field_76771_b;
                }
            }
            if (BiomeProviderType.field_205461_c.func_206858_b().equals((Object)resourcelocation)) {
                SingleBiomeProviderSettings singlebiomeprovidersettings2 = ((SingleBiomeProviderSettings)fixedBiomeProvider.func_205458_a()).func_205436_a(abiome[0]);
                biomeprovider = fixedBiomeProvider.func_205457_a((IBiomeProviderSettings)singlebiomeprovidersettings2);
            }
            if (BiomeProviderType.field_205460_b.func_206858_b().equals((Object)resourcelocation)) {
                int j = jsonobject1.has("size") ? jsonobject1.getAsJsonPrimitive("size").getAsInt() : 2;
                CheckerboardBiomeProviderSettings checkerboardbiomeprovidersettings = ((CheckerboardBiomeProviderSettings)checkerBoardBiomeProvider.func_205458_a()).func_206860_a(abiome).func_206861_a(j);
                biomeprovider = checkerBoardBiomeProvider.func_205457_a((IBiomeProviderSettings)checkerboardbiomeprovidersettings);
            }
            if (BiomeProviderType.field_206859_d.func_206858_b().equals((Object)resourcelocation)) {
                OverworldBiomeProviderSettings overworldbiomeprovidersettings1 = ((OverworldBiomeProviderSettings)vanillaLayeredBiomeProvider.func_205458_a()).func_205441_a(new OverworldGenSettings()).func_205439_a((WorldInfo)new SeedFixWorldInfo(this.field_76579_a.func_72912_H()));
                biomeprovider = vanillaLayeredBiomeProvider.func_205457_a((IBiomeProviderSettings)overworldbiomeprovidersettings1);
            }
        }
        if (biomeprovider == null) {
            biomeprovider = fixedBiomeProvider.func_205457_a((IBiomeProviderSettings)((SingleBiomeProviderSettings)fixedBiomeProvider.func_205458_a()).func_205436_a(Biomes.field_76771_b));
        }
        IBlockState iblockstate = Blocks.field_150348_b.func_176223_P();
        IBlockState iblockstate1 = Blocks.field_150355_j.func_176223_P();
        if (jsonobject.has("chunk_generator") && jsonobject.getAsJsonObject("chunk_generator").has("options")) {
            String s1;
            Block block1;
            String s;
            Block block;
            if (jsonobject.getAsJsonObject("chunk_generator").getAsJsonObject("options").has("default_block") && (block = (Block)IRegistry.field_212618_g.func_82594_a(new ResourceLocation(s = jsonobject.getAsJsonObject("chunk_generator").getAsJsonObject("options").getAsJsonPrimitive("default_block").getAsString()))) != null) {
                iblockstate = block.func_176223_P();
            }
            if (jsonobject.getAsJsonObject("chunk_generator").getAsJsonObject("options").has("default_fluid") && (block1 = (Block)IRegistry.field_212618_g.func_82594_a(new ResourceLocation(s1 = jsonobject.getAsJsonObject("chunk_generator").getAsJsonObject("options").getAsJsonPrimitive("default_fluid").getAsString()))) != null) {
                iblockstate1 = block1.func_176223_P();
            }
        }
        if (jsonobject.has("chunk_generator") && jsonobject.getAsJsonObject("chunk_generator").has("type")) {
            ResourceLocation resourcelocation1 = new ResourceLocation(jsonobject.getAsJsonObject("chunk_generator").getAsJsonPrimitive("type").getAsString());
            if (ChunkGeneratorType.field_206912_c.func_205482_c().equals((Object)resourcelocation1)) {
                NetherGenSettings nethergensettings = (NetherGenSettings)cavesChunkGenerator.func_205483_a();
                nethergensettings.func_205535_a(iblockstate);
                nethergensettings.func_205534_b(iblockstate1);
                return cavesChunkGenerator.create(this.field_76579_a, biomeprovider, (IChunkGenSettings)nethergensettings);
            }
            if (ChunkGeneratorType.field_206913_d.func_205482_c().equals((Object)resourcelocation1)) {
                EndGenSettings endgensettings = (EndGenSettings)floatingIslandsChunkGenerator.func_205483_a();
                endgensettings.func_205538_a(new BlockPos(0, 64, 0));
                endgensettings.func_205535_a(iblockstate);
                endgensettings.func_205534_b(iblockstate1);
                return floatingIslandsChunkGenerator.create(this.field_76579_a, biomeprovider, (IChunkGenSettings)endgensettings);
            }
        }
        OverworldGenSettings overworldgensettings1 = (OverworldGenSettings)surfaceChunkGenerator.func_205483_a();
        overworldgensettings1.func_205535_a(iblockstate);
        overworldgensettings1.func_205534_b(iblockstate1);
        return surfaceChunkGenerator.create(this.field_76579_a, biomeprovider, (IChunkGenSettings)overworldgensettings1);
    }

    private WorldSaveDataDimension getSaveData() {
        return (WorldSaveDataDimension)WorldUtil.getSaveData((World)this.field_76579_a, (String)"overworldmirror", WorldSaveDataDimension::new);
    }
}

