/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.overworld_mirror.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ServerConfig {
    public static final ForgeConfigSpec CONFIG;
    private static final ServerConfig INSTANCE;
    public final ForgeConfigSpec.EnumValue<SeedType> seedType;
    public final ForgeConfigSpec.LongValue seedValue;
    public final ForgeConfigSpec.ConfigValue<String> generatorType;
    public final ForgeConfigSpec.ConfigValue<String> generatorSettings;
    public final ForgeConfigSpec.DoubleValue movementFactor;
    public final ForgeConfigSpec.DoubleValue portalDistance;

    public static ServerConfig getInstance() {
        return INSTANCE;
    }

    private ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Seed settings").push("seed");
        this.seedType = builder.comment("If you have set this to \"SEED\" then the seedValue value will be treated as new seed, else if its set to \"ADDITION\" the value will be added to the main world seed.").defineEnum("seedType", (Enum)SeedType.ADDITION);
        this.seedValue = builder.comment("The seed value. See seedType for more information.").defineInRange("seedValue", 100000L, Long.MIN_VALUE, Long.MAX_VALUE);
        builder.pop();
        builder.comment("Generation settings").push("generator");
        this.generatorType = builder.comment("Generator type e.g. default, flat, buffet, ... (See here for a list: https://minecraft.gamepedia.com/World_type)").define("generatorType", (Object)"default");
        this.generatorSettings = builder.comment("Generator settings for the generator type. The snbt string must be valid json and escaped. For flat worlds you must use the snbt variant like this: ({\"biome\":\"minecraft:plains\",\"layers\":[{\"block\":\"minecraft:bedrock\",\"height\":1},{\"block\":\"minecraft:dirt\",\"height\":2},{\"block\":\"minecraft:grass_block\",\"height\":1}],\"structures\":{\"village\":{}}}) and not the client side preset code (minecraft:bedrock,30*minecraft:dirt,minecraft:grass_block;minecraft:plains;village)").define("generatorSettings", (Object)"");
        builder.pop();
        builder.comment("Portal settings").push("portal");
        this.movementFactor = builder.comment("Movement factor. Like in the nether you move 8 times the block length as in the overworld").defineInRange("movementFactor", 1.0, 0.0, 1.0E10);
        this.portalDistance = builder.comment("How many blocks the portal can be from the normal spawn location to not create a new one. The value is not in sqrt cause of lag reduction. 400 = 20 Blocks, 900 = 30 Blocks, etc").defineInRange("portalDistance", 400.0, 1.0, 1.0E20);
        builder.pop();
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        CONFIG = (ForgeConfigSpec)pair.getRight();
        INSTANCE = (ServerConfig)pair.getLeft();
    }

    public static enum SeedType {
        SEED,
        ADDITION;


        public long calculateSeed(long seedValue, long worldSeed) {
            if (this == SEED) {
                return seedValue;
            }
            return worldSeed + seedValue;
        }
    }
}

