/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.overworld_mirror.dimension;

import info.u_team.overworld_mirror.config.ServerConfig;
import info.u_team.overworld_mirror.dimension.OverworldMirrorWorldInfo;
import info.u_team.overworld_mirror.dimension.TimeWorldSavedData;
import info.u_team.u_team_core.util.world.WorldUtil;
import java.util.Optional;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.dimension.OverworldDimension;
import net.minecraft.world.server.ServerWorld;

public class OverworldMirrorDimension
extends OverworldDimension {
    private TimeWorldSavedData timeData;

    public OverworldMirrorDimension(World world, DimensionType type) {
        super(world, type);
        world.field_72986_A = new OverworldMirrorWorldInfo(world.field_72986_A);
    }

    public double getMovementFactor() {
        return (Double)ServerConfig.getInstance().movementFactor.get();
    }

    public void setWorldTime(long time) {
        super.setWorldTime(time);
        this.getTimeData().ifPresent(data -> data.setTime(time));
    }

    public long getWorldTime() {
        if (this.timeData == null && this.field_76579_a instanceof ServerWorld) {
            this.getTimeData().ifPresent(data -> super.setWorldTime(data.getTime()));
        }
        return super.getWorldTime();
    }

    private Optional<TimeWorldSavedData> getTimeData() {
        if (this.timeData == null && this.field_76579_a instanceof ServerWorld) {
            String name = "time";
            this.timeData = (TimeWorldSavedData)WorldUtil.getSaveData((ServerWorld)((ServerWorld)this.field_76579_a), (String)"time", () -> new TimeWorldSavedData("time"));
        }
        return Optional.ofNullable(this.timeData);
    }
}

