/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.overworld_mirror.portal;

import info.u_team.overworld_mirror.config.ServerConfig;
import info.u_team.overworld_mirror.init.OverworldMirrorBlocks;
import info.u_team.overworld_mirror.portal.PortalWorldSavedData;
import info.u_team.u_team_core.util.world.WorldUtil;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class PortalManager {
    public static boolean trySpawnPortalFromFrame(ServerWorld world, BlockPos pos) {
        int northCount;
        int westCount;
        for (westCount = 0; world.func_180495_p(pos.func_177985_f(westCount + 1)).func_177230_c() != Blocks.field_196696_di && westCount < 3; ++westCount) {
        }
        BlockPos westPost = pos.func_177985_f(westCount);
        for (northCount = 0; world.func_180495_p(westPost.func_177964_d(northCount + 1)).func_177230_c() != Blocks.field_196696_di && northCount < 3; ++northCount) {
        }
        BlockPos westNorthPos = westPost.func_177964_d(northCount);
        BlockPos middlePos = westNorthPos.func_177974_f().func_177968_d();
        if (!PortalManager.validatePortalFrameAndSpawnPortal((World)world, middlePos)) {
            return false;
        }
        PortalWorldSavedData data = PortalManager.getSavedData(world);
        data.getPortals().add(middlePos);
        data.func_76185_a();
        return true;
    }

    private static boolean validatePortalFrameAndSpawnPortal(World world, BlockPos pos) {
        int i;
        ArrayList<BlockPos> flowers = new ArrayList<BlockPos>();
        ArrayList<BlockPos> frame = new ArrayList<BlockPos>();
        for (i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                flowers.add(pos.func_177982_a(i, 0, j));
            }
        }
        for (i = -1; i <= 1; ++i) {
            frame.add(pos.func_177982_a(2, 0, i));
            frame.add(pos.func_177982_a(-2, 0, i));
            frame.add(pos.func_177982_a(i, 0, 2));
            frame.add(pos.func_177982_a(i, 0, -2));
        }
        boolean flowersMatching = flowers.stream().allMatch(flowerPos -> world.func_180495_p(flowerPos).func_177230_c() instanceof FlowerBlock);
        boolean frameMatching = frame.stream().allMatch(framePos -> world.func_180495_p(framePos).func_177230_c() == Blocks.field_196696_di);
        if (flowersMatching && frameMatching) {
            flowers.forEach(portalPos -> world.func_180501_a(portalPos, OverworldMirrorBlocks.PORTAL.func_176223_P(), 2));
            PlayerList playerlist = world.func_73046_m().func_184103_al();
            flowers.forEach(portalPos -> playerlist.func_148543_a(null, (double)portalPos.func_177958_n(), (double)portalPos.func_177956_o(), (double)portalPos.func_177952_p(), 64.0, world.func_201675_m().func_186058_p(), (IPacket)new SChangeBlockPacket((IBlockReader)world, portalPos)));
            return true;
        }
        return false;
    }

    public static void trySummonEntityInPortal(ServerWorld world, Entity entity, float yaw) {
        BlockPos entityPos = entity.func_180425_c();
        PortalWorldSavedData data = PortalManager.getSavedData(world);
        BlockPos middlePos = null;
        Iterator<BlockPos> iterator = data.getPortals().iterator();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            if (!(PortalManager.distanceSq(pos.func_177958_n(), pos.func_177952_p(), entityPos.func_177958_n(), entityPos.func_177952_p()) < (Double)ServerConfig.getInstance().portalDistance.get())) continue;
            if (PortalManager.validatePortal((World)world, pos)) {
                middlePos = pos;
                break;
            }
            iterator.remove();
            data.func_76185_a();
        }
        if (middlePos == null) {
            middlePos = PortalManager.spawnPortal((World)world, entityPos);
            data.getPortals().add(middlePos);
            data.func_76185_a();
        }
        entity.func_70080_a((double)middlePos.func_177958_n() + 0.5, (double)middlePos.func_177956_o(), (double)((float)middlePos.func_177952_p() + 0.5f), yaw, entity.field_70125_A);
    }

    private static boolean validatePortal(World world, BlockPos pos) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (world.func_180495_p(pos.func_177982_a(i, 0, j)).func_177230_c() == OverworldMirrorBlocks.PORTAL) continue;
                return false;
            }
        }
        return true;
    }

    private static BlockPos spawnPortal(World world, BlockPos entityPos) {
        int i;
        world.func_217349_x(entityPos);
        BlockPos pos = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, entityPos).func_177977_b();
        ArrayList<BlockPos> portal = new ArrayList<BlockPos>();
        ArrayList<BlockPos> frame = new ArrayList<BlockPos>();
        for (i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                portal.add(pos.func_177982_a(i, 0, j));
            }
        }
        for (i = -2; i <= 2; ++i) {
            frame.add(pos.func_177982_a(2, 0, i));
            frame.add(pos.func_177982_a(-2, 0, i));
            frame.add(pos.func_177982_a(i, 0, 2));
            frame.add(pos.func_177982_a(i, 0, -2));
        }
        frame.forEach(framePos -> {
            world.func_175656_a(framePos, Blocks.field_196696_di.func_176223_P());
            world.func_217377_a(framePos.func_177984_a(), false);
            world.func_217377_a(framePos.func_177981_b(2), false);
        });
        portal.forEach(portalPos -> {
            world.func_217377_a(portalPos.func_177984_a(), false);
            world.func_217377_a(portalPos.func_177981_b(2), false);
            world.func_175656_a(portalPos.func_177977_b(), Blocks.field_196696_di.func_176223_P());
        });
        portal.forEach(portalPos -> world.func_180501_a(portalPos, OverworldMirrorBlocks.PORTAL.func_176223_P(), 2));
        return pos;
    }

    public static PortalWorldSavedData getSavedData(ServerWorld world) {
        String name = "overworldmirror_portal";
        return (PortalWorldSavedData)WorldUtil.getSaveData((ServerWorld)world, (String)"overworldmirror_portal", () -> new PortalWorldSavedData("overworldmirror_portal"));
    }

    public static double distanceSq(double fromX, double fromZ, double toX, double toZ) {
        double x = fromX - toX;
        double z = fromZ - toZ;
        return x * x + z * z;
    }
}

