/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.overworld_mirror.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ServerConfig {
    public static final ForgeConfigSpec CONFIG;
    private static final ServerConfig INSTANCE;
    public final ForgeConfigSpec.EnumValue<SeedType> seedType;
    public final ForgeConfigSpec.LongValue seedValue;
    public final ForgeConfigSpec.DoubleValue portalSearchDistanceOverworld;
    public final ForgeConfigSpec.DoubleValue portalSearchDistanceOverworldMirror;

    public static ServerConfig getInstance() {
        return INSTANCE;
    }

    private ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("To configure the dimension type please create a data pack and add a dimension type in this resource location: data/overworldmirror/dimension_type/overworld_mirror.json").push("information");
        builder.define("information", (Object)"");
        builder.pop();
        builder.comment("Seed settings").push("seed");
        this.seedType = builder.comment("If you have set this to \"SEED\" then the seedValue value will be treated as new seed, else if its set to \"ADDITION\" the value will be added to the main world seed.").defineEnum("seedType", (Enum)SeedType.ADDITION);
        this.seedValue = builder.comment("The seed value. See seedType for more information.").defineInRange("seedValue", 100000L, Long.MIN_VALUE, Long.MAX_VALUE);
        builder.pop();
        builder.comment("Portal settings").push("portal");
        this.portalSearchDistanceOverworld = builder.comment("How many blocks the portal can be from the normal spawn location to not create a new one.").defineInRange("portalSearchDistanceOverworld", 30.0, 1.0, 1.0E10);
        this.portalSearchDistanceOverworldMirror = builder.comment("How many blocks the portal can be from the normal spawn location to not create a new one.").defineInRange("portalSearchDistanceOverworldMirror", 30.0, 1.0, 1.0E10);
        builder.pop();
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        CONFIG = (ForgeConfigSpec)pair.getRight();
        INSTANCE = (ServerConfig)pair.getLeft();
    }

    public static enum SeedType {
        SEED,
        ADDITION;


        public long calculateSeed(long seedValue, long worldSeed) {
            if (this == SEED) {
                return seedValue;
            }
            return worldSeed + seedValue;
        }
    }
}

