/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.overworld_mirror.init;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Lifecycle;
import info.u_team.overworld_mirror.config.ServerConfig;
import info.u_team.overworld_mirror.init.OverworldMirrorDimensionKeys;
import info.u_team.overworld_mirror.init.OverworldMirrorDimensionTypeKeys;
import info.u_team.overworld_mirror.init.OverworldMirrorWorldKeys;
import java.util.List;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DerivedWorldInfo;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;

public class OverworldMirrorDimensionRegistry {
    private static void serverStarting(FMLServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        Map worlds = server.forgeGetWorldMap();
        if (!worlds.containsKey(OverworldMirrorWorldKeys.MIRROR_OVERWORLD)) {
            IServerConfiguration serverConfig = server.func_240793_aU_();
            DimensionGeneratorSettings dimensionSettings = serverConfig.func_230418_z_();
            DynamicRegistries registries = server.func_244267_aX();
            long seed = ((ServerConfig.SeedType)((Object)ServerConfig.getInstance().seedType.get())).calculateSeed((Long)ServerConfig.getInstance().seedValue.get(), dimensionSettings.func_236221_b_());
            DimensionType type = (DimensionType)registries.func_230520_a_().func_243576_d(OverworldMirrorDimensionTypeKeys.MIRROR_OVERWORLD);
            NoiseChunkGenerator generator = DimensionGeneratorSettings.func_242750_a((Registry)registries.func_243612_b(Registry.field_239720_u_), (Registry)registries.func_243612_b(Registry.field_243549_ar), (long)seed);
            Dimension dimension = new Dimension(() -> type, (ChunkGenerator)generator);
            dimensionSettings.func_236224_e_().func_218381_a(OverworldMirrorDimensionKeys.MIRROR_OVERWORLD, (Object)dimension, Lifecycle.experimental());
            DerivedWorldInfo worldInfo = new DerivedWorldInfo(serverConfig, serverConfig.func_230407_G_());
            ServerWorld world = new ServerWorld(server, server.field_213217_au, server.field_71310_m, (IServerWorldInfo)worldInfo, OverworldMirrorWorldKeys.MIRROR_OVERWORLD, dimension.func_236063_b_(), server.field_213220_d.create(11), dimension.func_236064_c_(), dimensionSettings.func_236227_h_(), BiomeManager.func_235200_a_((long)seed), (List)ImmutableList.of(), false);
            server.func_71218_a(World.field_234918_g_).func_175723_af().func_177737_a((IBorderListener)new IBorderListener.Impl(world.func_175723_af()));
            worlds.put(OverworldMirrorWorldKeys.MIRROR_OVERWORLD, world);
            server.markWorldsDirty();
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((IWorld)worlds.get(OverworldMirrorWorldKeys.MIRROR_OVERWORLD)));
        }
    }

    public static void registerForge(IEventBus bus) {
        bus.addListener(OverworldMirrorDimensionRegistry::serverStarting);
    }
}

