/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructurePieceType;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import tictim.paraglider.contents.worldgen.NetherHornedStatuePiece;
import tictim.paraglider.contents.worldgen.NetherHornedStatueStructure;
import tictim.paraglider.contents.worldgen.TarreyTownGoddessStatuePiece;
import tictim.paraglider.contents.worldgen.TarreyTownGoddessStatueStructure;
import tictim.paraglider.contents.worldgen.UndergroundHornedStatuePiece;
import tictim.paraglider.contents.worldgen.UndergroundHornedStatueStructure;

@Mod.EventBusSubscriber(modid="paraglider", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModStructures {
    public static final UndergroundHornedStatueStructure UNDERGROUND_HORNED_STATUE = new UndergroundHornedStatueStructure();
    public static final StructurePieceType UNDERGROUND_HORNED_STATUE_PIECE_TYPE = UndergroundHornedStatuePiece::new;
    public static final ConfiguredStructureFeature<?, ?> UNDERGROUND_HORNED_STATUE_CONFIGURED = UNDERGROUND_HORNED_STATUE.m_67065_((FeatureConfiguration)NoneFeatureConfiguration.f_67737_);
    public static final StructureFeatureConfiguration UNDERGROUND_HORNED_STATUE_SEPARATION_SETTINGS = new StructureFeatureConfiguration(16, 8, 49788929);
    public static final NetherHornedStatueStructure NETHER_HORNED_STATUE = new NetherHornedStatueStructure();
    public static final StructurePieceType NETHER_HORNED_STATUE_PIECE_TYPE = NetherHornedStatuePiece::new;
    public static final ConfiguredStructureFeature<?, ?> NETHER_HORNED_STATUE_CONFIGURED = NETHER_HORNED_STATUE.m_67065_((FeatureConfiguration)NoneFeatureConfiguration.f_67737_);
    public static final StructureFeatureConfiguration NETHER_HORNED_STATUE_SEPARATION_SETTINGS = new StructureFeatureConfiguration(32, 8, 1973135446);
    public static final TarreyTownGoddessStatueStructure TARREY_TOWN_GODDESS_STATUE = new TarreyTownGoddessStatueStructure();
    public static final StructurePieceType TARREY_TOWN_GODDESS_STATUE_PIECE_TYPE = TarreyTownGoddessStatuePiece::new;
    public static final ConfiguredStructureFeature<?, ?> TARREY_TOWN_GODDESS_STATUE_CONFIGURED = TARREY_TOWN_GODDESS_STATUE.m_67065_((FeatureConfiguration)NoneFeatureConfiguration.f_67737_);
    public static final StructureFeatureConfiguration TARREY_TOWN_GODDESS_STATUE_SEPARATION_SETTINGS = new StructureFeatureConfiguration(32, 8, 850796625);

    private ModStructures() {
    }

    @SubscribeEvent
    public static void registerStructure(RegistryEvent.Register<StructureFeature<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        ModStructures.register(registry, UNDERGROUND_HORNED_STATUE, UNDERGROUND_HORNED_STATUE_PIECE_TYPE, UNDERGROUND_HORNED_STATUE_CONFIGURED, UNDERGROUND_HORNED_STATUE_SEPARATION_SETTINGS, "underground_horned_statue");
        ModStructures.register(registry, NETHER_HORNED_STATUE, NETHER_HORNED_STATUE_PIECE_TYPE, NETHER_HORNED_STATUE_CONFIGURED, NETHER_HORNED_STATUE_SEPARATION_SETTINGS, "nether_horned_statue");
        ModStructures.register(registry, TARREY_TOWN_GODDESS_STATUE, TARREY_TOWN_GODDESS_STATUE_PIECE_TYPE, TARREY_TOWN_GODDESS_STATUE_CONFIGURED, TARREY_TOWN_GODDESS_STATUE_SEPARATION_SETTINGS, "tarrey_town_goddess_statue");
    }

    private static void register(IForgeRegistry<StructureFeature<?>> registry, StructureFeature<?> structure, StructurePieceType structurePieceType, ConfiguredStructureFeature<?, ?> structureFeature, StructureFeatureConfiguration separationSettings, String structureName) {
        ResourceLocation key = new ResourceLocation("paraglider", structureName);
        registry.register((IForgeRegistryEntry)((StructureFeature)structure.setRegistryName(key)));
        StructureFeature.f_67012_.put((Object)key.toString(), structure);
        StructureSettings.f_64580_ = ImmutableMap.builder().putAll((Map)StructureSettings.f_64580_).put(structure, (Object)separationSettings).build();
        Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)key, (Object)structurePieceType);
        Registry.m_122965_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)key, structureFeature);
        FlatLevelGeneratorSettings.f_70349_.put(structure, structureFeature);
    }
}

