/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.structures.StructurePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import tictim.paraglider.ModCfg;
import tictim.paraglider.ParagliderMod;

public final class ModVillageStructures {
    private ModVillageStructures() {
    }

    public static void addVillageStructures() {
        if (!ModCfg.enableStructures()) {
            return;
        }
        ParagliderMod.LOGGER.debug("Start adding village structures");
        ModVillageStructures.appendPool(new ResourceLocation("village/desert/houses"), a -> {
            a.append(StructurePoolElement.m_69192_((String)"paraglider:gerudo_village_goddess_statue"), 1);
            a.append(StructurePoolElement.m_69192_((String)"paraglider:desert_village_horned_statue"), 1);
        });
        ModVillageStructures.appendPool(new ResourceLocation("village/plains/houses"), a -> {
            a.append(StructurePoolElement.m_69192_((String)"paraglider:hateno_village_goddess_statue"), 1);
            a.append(StructurePoolElement.m_69192_((String)"paraglider:plains_village_horned_statue"), 1);
        });
        ModVillageStructures.appendPool(new ResourceLocation("village/savanna/houses"), a -> {
            a.append(StructurePoolElement.m_69192_((String)"paraglider:rito_village_goddess_statue"), 3);
            a.append(StructurePoolElement.m_69192_((String)"paraglider:savanna_village_horned_statue"), 1);
        });
        ModVillageStructures.appendPool(new ResourceLocation("village/snowy/houses"), a -> a.append(StructurePoolElement.m_69192_((String)"paraglider:snowy_village_horned_statue"), 1));
        ModVillageStructures.appendPool(new ResourceLocation("village/taiga/houses"), a -> {
            a.append(StructurePoolElement.m_69192_((String)"paraglider:kakariko_village_goddess_statue"), 3);
            a.append(StructurePoolElement.m_69192_((String)"paraglider:taiga_village_horned_statue"), 1);
        });
        ParagliderMod.LOGGER.debug("Finished adding village structures");
    }

    private static void appendPool(ResourceLocation pool, Consumer<PoolAppender> c) {
        StructureTemplatePool old = (StructureTemplatePool)BuiltinRegistries.f_123864_.m_7745_(pool);
        if (old == null || old == Pools.m_127189_()) {
            ParagliderMod.LOGGER.warn("Jigsaw pool '{}' doesn't exists", (Object)pool);
            return;
        }
        PoolAppender appender = new PoolAppender();
        c.accept(appender);
        if (appender.structureToWeight.isEmpty()) {
            return;
        }
        ArrayList<Pair<StructurePoolElement, Integer>> newWeightedPool = new ArrayList<Pair<StructurePoolElement, Integer>>();
        newWeightedPool.addAll(old.f_69249_);
        newWeightedPool.addAll(appender.structureToWeight);
        Registry.m_122965_((Registry)BuiltinRegistries.f_123864_, (ResourceLocation)pool, (Object)new StructureTemplatePool(pool, old.m_69275_(), newWeightedPool));
        ParagliderMod.LOGGER.debug("Added {} elements to jigsaw pool '{}'", (Object)appender.structureToWeight.size(), (Object)pool);
    }

    private static final class PoolAppender {
        private final List<Pair<StructurePoolElement, Integer>> structureToWeight = new ArrayList<Pair<StructurePoolElement, Integer>>();

        private PoolAppender() {
        }

        public void append(Function<StructureTemplatePool.Projection, ? extends StructurePoolElement> factory, int weight) {
            this.structureToWeight.add((Pair<StructurePoolElement, Integer>)new Pair((Object)factory.apply(StructureTemplatePool.Projection.RIGID), (Object)weight));
        }
    }
}

