/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.AbstractObject2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.utils.QuantifiedIngredient;

public class StatueBargainBuilder {
    protected ResourceLocation bargainOwner;
    protected final List<QuantifiedIngredient> itemDemands = new ArrayList<QuantifiedIngredient>();
    protected int heartContainerDemands;
    protected int staminaVesselDemands;
    protected int essenceDemands;
    protected final List<Object2IntMap.Entry<Item>> itemOffers = new ArrayList<Object2IntMap.Entry<Item>>();
    protected int heartContainerOffers;
    protected int staminaVesselOffers;
    protected int essenceOffers;
    protected final List<ICondition> conditions = new ArrayList<ICondition>();

    public StatueBargainBuilder(ResourceLocation bargainOwner) {
        this.bargainOwner = Objects.requireNonNull(bargainOwner);
    }

    public StatueBargainBuilder demand(ItemLike item, int quantity) {
        return this.demand(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), quantity);
    }

    public StatueBargainBuilder demand(Tag<Item> tag, int quantity) {
        return this.demand(Ingredient.m_43911_(tag), quantity);
    }

    public StatueBargainBuilder demand(Ingredient ingredient, int quantity) {
        this.itemDemands.add(new QuantifiedIngredient(ingredient, quantity));
        return this;
    }

    public StatueBargainBuilder demandHeartContainer(int quantity) {
        this.heartContainerDemands = quantity;
        return this;
    }

    public StatueBargainBuilder demandStaminaVessel(int quantity) {
        this.staminaVesselDemands = quantity;
        return this;
    }

    public StatueBargainBuilder demandEssence(int quantity) {
        this.essenceDemands = quantity;
        return this;
    }

    public StatueBargainBuilder offer(Item item, int count) {
        this.itemOffers.add((Object2IntMap.Entry<Item>)new AbstractObject2IntMap.BasicEntry((Object)item, count));
        return this;
    }

    public StatueBargainBuilder offerHeartContainer(int quantity) {
        this.heartContainerOffers = quantity;
        return this;
    }

    public StatueBargainBuilder offerStaminaVessel(int quantity) {
        this.staminaVesselOffers = quantity;
        return this;
    }

    public StatueBargainBuilder offerEssence(int quantity) {
        this.essenceOffers = quantity;
        return this;
    }

    public StatueBargainBuilder condition(ICondition condition) {
        this.conditions.add(Objects.requireNonNull(condition));
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.bargainOwner, this.itemDemands, this.heartContainerDemands, this.staminaVesselDemands, this.essenceDemands, this.itemOffers, this.heartContainerOffers, this.staminaVesselOffers, this.essenceOffers, this.conditions));
    }

    public static class Result
    implements FinishedRecipe {
        protected final ResourceLocation id;
        protected final ResourceLocation bargainOwner;
        protected final List<QuantifiedIngredient> itemDemands;
        protected final int heartContainerDemands;
        protected final int staminaVesselDemands;
        protected final int essenceDemands;
        protected final List<Object2IntMap.Entry<Item>> itemOffers;
        protected final int heartContainerOffers;
        protected final int staminaVesselOffers;
        protected final int essenceOffers;
        protected final List<ICondition> conditions;

        public Result(ResourceLocation id, ResourceLocation bargainOwner, List<QuantifiedIngredient> itemDemands, int heartContainerDemands, int staminaVesselDemands, int essenceDemands, List<Object2IntMap.Entry<Item>> itemOffers, int heartContainerOffers, int staminaVesselOffers, int essenceOffers, List<ICondition> conditions) {
            this.id = id;
            this.bargainOwner = bargainOwner;
            this.itemDemands = itemDemands;
            this.heartContainerDemands = heartContainerDemands;
            this.staminaVesselDemands = staminaVesselDemands;
            this.essenceDemands = essenceDemands;
            this.itemOffers = itemOffers;
            this.heartContainerOffers = heartContainerOffers;
            this.staminaVesselOffers = staminaVesselOffers;
            this.essenceOffers = essenceOffers;
            this.conditions = conditions;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("owner", this.bargainOwner.toString());
            if (!this.itemDemands.isEmpty() || this.heartContainerDemands > 0 || this.staminaVesselDemands > 0 || this.essenceDemands > 0) {
                JsonObject demands = new JsonObject();
                if (!this.itemDemands.isEmpty()) {
                    demands.add("items", (JsonElement)this.itemDemands.stream().collect(() -> new JsonArray(), (e, i) -> e.add(i.serialize()), (e1, e2) -> {}));
                }
                if (this.heartContainerDemands > 0) {
                    demands.addProperty("heartContainers", (Number)this.heartContainerDemands);
                }
                if (this.staminaVesselDemands > 0) {
                    demands.addProperty("staminaVessels", (Number)this.staminaVesselDemands);
                }
                if (this.essenceDemands > 0) {
                    demands.addProperty("essences", (Number)this.essenceDemands);
                }
                json.add("demands", (JsonElement)demands);
            }
            if (!this.itemOffers.isEmpty() || this.heartContainerOffers > 0 || this.staminaVesselOffers > 0 || this.essenceOffers > 0) {
                JsonObject offers = new JsonObject();
                if (!this.itemOffers.isEmpty()) {
                    offers.add("items", (JsonElement)this.itemOffers.stream().collect(() -> new JsonArray(), (e, i) -> {
                        JsonObject o = new JsonObject();
                        ResourceLocation key = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)((Item)i.getKey()));
                        o.addProperty("item", key.toString());
                        if (i.getIntValue() != 1) {
                            o.addProperty("count", (Number)i.getIntValue());
                        }
                        e.add((JsonElement)o);
                    }, (e1, e2) -> {}));
                }
                if (this.heartContainerOffers > 0) {
                    offers.addProperty("heartContainers", (Number)this.heartContainerOffers);
                }
                if (this.staminaVesselOffers > 0) {
                    offers.addProperty("staminaVessels", (Number)this.staminaVesselOffers);
                }
                if (this.essenceOffers > 0) {
                    offers.addProperty("essences", (Number)this.essenceOffers);
                }
                json.add("offers", (JsonElement)offers);
            }
            if (!this.conditions.isEmpty()) {
                JsonArray a = new JsonArray();
                for (ICondition c : this.conditions) {
                    a.add((JsonElement)CraftingHelper.serialize((ICondition)c));
                }
                json.add("conditions", (JsonElement)a);
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)Contents.STATUE_BARGAIN_RECIPE.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

