/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.event;

import java.util.HashMap;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import tictim.paraglider.ModCfg;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.capabilities.ClientPlayerMovement;
import tictim.paraglider.capabilities.PlayerMovement;
import tictim.paraglider.capabilities.RemotePlayerMovement;
import tictim.paraglider.capabilities.ServerPlayerMovement;
import tictim.paraglider.contents.ModStructures;
import tictim.paraglider.network.ModNet;
import tictim.paraglider.network.SyncParaglidingMsg;

@Mod.EventBusSubscriber(modid="paraglider")
public final class ParagliderEventHandler {
    private static final double DEFAULT_PARAGLIDING_SPEED = 0.02599999986588955;
    private static final ResourceLocation MOVEMENT_HANDLER_KEY = new ResourceLocation("paraglider", "paragliding_movement_handler");

    private ParagliderEventHandler() {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void loadBiome(BiomeLoadingEvent event) {
        switch (event.getCategory()) {
            case EXTREME_HILLS: 
            case MESA: 
            case PLAINS: 
            case SAVANNA: {
                event.getGeneration().getStructures().add(() -> ModStructures.TARREY_TOWN_GODDESS_STATUE_CONFIGURED);
            }
            case NONE: 
            case TAIGA: 
            case FOREST: 
            case JUNGLE: 
            case ICY: 
            case BEACH: 
            case DESERT: 
            case RIVER: 
            case MUSHROOM: {
                event.getGeneration().getStructures().add(() -> ModStructures.UNDERGROUND_HORNED_STATUE_CONFIGURED);
                break;
            }
            case NETHER: {
                ResourceLocation name = event.getName();
                if (name != null && (name.equals((Object)Biomes.f_48175_.m_135782_()) || name.equals((Object)Biomes.f_48200_.m_135782_()))) break;
                event.getGeneration().getStructures().add(() -> ModStructures.NETHER_HORNED_STATUE_CONFIGURED);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        if (level.m_7726_().m_8481_() instanceof FlatLevelSource && level.m_46472_().equals((Object)Level.f_46428_)) {
            return;
        }
        HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(level.m_7726_().f_8328_.m_62205_().m_64590_());
        if (ModCfg.enableStructures()) {
            tempMap.put(ModStructures.UNDERGROUND_HORNED_STATUE, ModStructures.UNDERGROUND_HORNED_STATUE_SEPARATION_SETTINGS);
            tempMap.put(ModStructures.NETHER_HORNED_STATUE, ModStructures.NETHER_HORNED_STATUE_SEPARATION_SETTINGS);
            tempMap.put(ModStructures.TARREY_TOWN_GODDESS_STATUE, ModStructures.TARREY_TOWN_GODDESS_STATUE_SEPARATION_SETTINGS);
        } else {
            tempMap.remove((Object)ModStructures.UNDERGROUND_HORNED_STATUE);
            tempMap.remove((Object)ModStructures.NETHER_HORNED_STATUE);
            tempMap.remove((Object)ModStructures.TARREY_TOWN_GODDESS_STATUE);
        }
        level.m_7726_().f_8328_.m_62205_().f_64582_ = tempMap;
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent event) {
        ServerPlayerMovement m;
        if (event.isCancelable() && event.getHand() == InteractionHand.OFF_HAND && (m = ServerPlayerMovement.of((ICapabilityProvider)event.getPlayer())) != null && m.isParagliding()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        original.reviveCaps();
        PlayerMovement m1 = PlayerMovement.of((ICapabilityProvider)original);
        PlayerMovement m2 = PlayerMovement.of((ICapabilityProvider)event.getPlayer());
        if (m1 != null && m2 != null) {
            m1.copyTo(m2);
        }
        original.invalidateCaps();
    }

    @SubscribeEvent
    public static void onPlayerUseItem(LivingEntityUseItemEvent.Tick event) {
        ServerPlayerMovement m;
        if (event.getEntityLiving().m_7655_() == InteractionHand.OFF_HAND && event.getEntityLiving() instanceof Player && (m = ServerPlayerMovement.of((ICapabilityProvider)event.getEntityLiving())) != null && m.isParagliding()) {
            event.getEntityLiving().m_5810_();
        }
    }

    @SubscribeEvent
    public static void onAttachPlayerCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player p = (Player)object;
            PlayerMovement m = p instanceof ServerPlayer ? new ServerPlayerMovement((ServerPlayer)p) : (PlayerMovement)DistExecutor.unsafeRunForDist(() -> () -> Client.createPlayerMovement(p), () -> () -> new RemotePlayerMovement(p));
            event.addCapability(MOVEMENT_HANDLER_KEY, (ICapabilityProvider)m);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerMovement h = PlayerMovement.of((ICapabilityProvider)event.player);
        if (h != null) {
            if (event.phase == TickEvent.Phase.END) {
                h.update();
            } else if (h.isParagliding()) {
                double v = ModCfg.paraglidingSpeed();
                event.player.f_20887_ = (float)(0.02599999986588955 * v);
            }
        }
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayerMovement h = ServerPlayerMovement.of((ICapabilityProvider)event.getPlayer());
        if (h != null) {
            h.movementNeedsSync = true;
            h.paraglidingNeedsSync = true;
            h.vesselNeedsSync = true;
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Player player = event.getPlayer();
        Player player2 = player;
        if (player2 instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player2;
            PlayerMovement h = PlayerMovement.of((ICapabilityProvider)event.getTarget());
            if (h != null) {
                SyncParaglidingMsg msg = new SyncParaglidingMsg(h);
                if (ModCfg.traceParaglidingPacket()) {
                    ParagliderMod.LOGGER.debug("Sending packet {} from player {} to player {}", (Object)msg, (Object)h.player, (Object)player);
                }
                ModNet.NET.send(PacketDistributor.PLAYER.with(() -> sp), (Object)msg);
            }
        }
    }

    private static final class Client {
        private Client() {
        }

        public static PlayerMovement createPlayerMovement(Player player) {
            return player instanceof LocalPlayer ? new ClientPlayerMovement(player) : new RemotePlayerMovement(player);
        }
    }
}

