/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.event;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import tictim.paraglider.capabilities.Paraglider;
import tictim.paraglider.network.ModNet;
import tictim.paraglider.network.SyncWindMsg;
import tictim.paraglider.wind.Wind;
import tictim.paraglider.wind.WindChunk;
import tictim.paraglider.wind.WindUpdater;

@Mod.EventBusSubscriber(modid="paraglider")
public final class WindEventHandler {
    private static final ResourceLocation WIND_KEY = new ResourceLocation("paraglider", "wind");

    private WindEventHandler() {
    }

    @SubscribeEvent
    public static void onAttachWorldCapabilities(AttachCapabilitiesEvent<Level> event) {
        event.addCapability(WIND_KEY, (ICapabilityProvider)new Wind());
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        List players;
        if (event.phase != TickEvent.Phase.END || !event.side.isServer()) {
            return;
        }
        WindUpdater placer = new WindUpdater();
        long gameTime = event.world.m_46467_();
        if (gameTime % 4L == 0L && !(players = event.world.m_6907_()).isEmpty()) {
            for (Player player : players) {
                if (!Paraglider.isParaglider(player.m_21205_())) continue;
                placer.placeAround(player);
            }
        }
        placer.checkPlacedWind(event.world);
        for (WindChunk windChunk : placer.getModifiedChunks()) {
            LevelChunk chunk = event.world.m_6325_(windChunk.getChunkPos().f_45578_, windChunk.getChunkPos().f_45579_);
            ModNet.NET.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)new SyncWindMsg(windChunk));
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        Wind wind = Wind.of((ICapabilityProvider)level);
        if (wind != null) {
            wind.remove(event.getChunk().m_7697_());
        }
    }

    @SubscribeEvent
    public static void onChunkWatch(ChunkWatchEvent.Watch event) {
        ServerLevel level = event.getWorld();
        Wind wind = Wind.of((ICapabilityProvider)level);
        if (wind == null) {
            return;
        }
        ChunkPos pos = event.getPos();
        WindChunk windChunk = wind.get(pos);
        if (windChunk == null || windChunk.isEmpty()) {
            return;
        }
        LevelChunk chunk = level.m_6325_(pos.f_45578_, pos.f_45579_);
        ModNet.NET.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)new SyncWindMsg(windChunk));
    }
}

