/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.loot;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import tictim.paraglider.utils.ParagliderUtils;

public class VesselLootModifier
extends LootModifier {
    private final int count;

    public VesselLootModifier(LootItemCondition[] conditionsIn) {
        this(conditionsIn, 0);
    }

    public VesselLootModifier(LootItemCondition[] conditionsIn, int count) {
        super(conditionsIn);
        this.count = count;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Item item = ParagliderUtils.getAppropriateVessel();
        if (item != null) {
            generatedLoot.add(new ItemStack((ItemLike)item, this.count));
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<VesselLootModifier> {
        public VesselLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] lootConditions) {
            return new VesselLootModifier(lootConditions, GsonHelper.m_13927_((JsonObject)object, (String)"count"));
        }

        public JsonObject write(VesselLootModifier instance) {
            JsonObject jsonObject = this.makeConditions(instance.conditions);
            jsonObject.addProperty("count", (Number)instance.count);
            return jsonObject;
        }
    }
}

