/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.wind;

import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;

public final class WindNode {
    private static final long WIND_LIFESPAN = 200L;
    @Nullable
    public WindNode next;
    public int x;
    public int y;
    public int z;
    public int height;
    public long createdTime;
    public long updatedTime;

    public WindNode(int x, int y, int z, int height, long createdTime) {
        this(x, y, z, height, createdTime, createdTime);
    }

    public WindNode(int x, int y, int z, int height, long createdTime, long updatedTime) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.height = height;
        this.createdTime = createdTime;
        this.updatedTime = updatedTime;
    }

    public WindNode(FriendlyByteBuf buf, int trailingSizeIncludingItself) {
        this.x = buf.readInt();
        this.y = buf.m_130242_();
        this.z = buf.readInt();
        this.height = buf.m_130242_();
        if (trailingSizeIncludingItself > 1) {
            this.next = new WindNode(buf, trailingSizeIncludingItself - 1);
        }
    }

    public boolean isExpired(long gameTime) {
        return gameTime - this.createdTime >= 200L;
    }

    public boolean overwrite(int y, int height, long createdTime) {
        if (this.y < y) {
            if (this.next != null) {
                return this.next.overwrite(y, height, createdTime);
            }
            this.next = new WindNode(this.x, y, this.z, height, createdTime);
            return true;
        }
        if (this.y == y) {
            this.updatedTime = this.createdTime = createdTime;
            if (this.height != height) {
                this.height = height;
                return true;
            }
            return false;
        }
        WindNode node = new WindNode(this.x, this.y, this.z, this.height, this.createdTime, this.updatedTime);
        node.next = this.next;
        this.next = node;
        this.y = y;
        this.height = height;
        this.updatedTime = this.createdTime = createdTime;
        return true;
    }

    public void write(FriendlyByteBuf buf) {
        int w = buf.writerIndex();
        buf.writeByte(0);
        int size = 0;
        WindNode n = this;
        while (n != null) {
            n.writeThis(buf);
            ++size;
            n = n.next;
        }
        buf.setByte(w, size);
    }

    private void writeThis(FriendlyByteBuf buf) {
        buf.writeInt(this.x);
        buf.m_130130_(this.y);
        buf.writeInt(this.z);
        buf.m_130130_(this.height);
    }
}

