/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.utils;

import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public record QuantifiedItem(ItemStack item, int quantity) {
    public QuantifiedItem(Item item, int quantity) {
        this(new ItemStack((ItemLike)item), Math.max(0, quantity));
    }

    public QuantifiedItem(ItemStack item, int quantity) {
        this.item = Objects.requireNonNull(item);
        this.quantity = Math.max(0, quantity);
    }

    public QuantifiedItem(JsonObject object) {
        this(QuantifiedItem.parseItemStack(object), GsonHelper.m_13824_((JsonObject)object, (String)"count", (int)1));
    }

    public static QuantifiedItem read(FriendlyByteBuf buffer) {
        return new QuantifiedItem(buffer.m_130267_(), buffer.m_130242_());
    }

    private static ItemStack parseItemStack(JsonObject object) {
        ItemStack stack = ShapedRecipe.m_151274_((JsonObject)object);
        stack.m_41764_(1);
        return stack;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public ItemStack getItemWithQuantity() {
        ItemStack copy = this.item.m_41777_();
        copy.m_41764_(this.quantity);
        return copy;
    }

    public JsonObject serialize() {
        JsonObject obj = new JsonObject();
        obj.addProperty("item", "" + ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.item.m_41720_()));
        if (this.quantity != 1) {
            obj.addProperty("count", (Number)this.quantity);
        }
        return obj;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.item);
        buffer.m_130130_(this.quantity);
    }
}

