/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;
import tictim.paraglider.ModCfg;
import tictim.paraglider.capabilities.Paraglider;
import tictim.paraglider.contents.Contents;

public class ParagliderItem
extends Item
implements DyeableLeatherItem {
    private final int defaultColor;

    public ParagliderItem(int defaultColor) {
        super(new Item.Properties().m_41487_(1).m_41491_(Contents.GROUP));
        this.defaultColor = defaultColor;
    }

    public int getMaxDamage(ItemStack stack) {
        return ModCfg.paragliderDurability();
    }

    public boolean m_41465_() {
        return ModCfg.paragliderDurability() > 0;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        ITagManager tags = ForgeRegistries.ITEMS.tags();
        return tags != null && tags.getTag(Tags.Items.LEATHER).contains((Object)repair.m_41720_());
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new Paraglider();
    }

    public int m_41121_(ItemStack stack) {
        CompoundTag nbt = stack.m_41737_("display");
        return nbt != null && nbt.m_128425_("color", 99) ? nbt.m_128451_("color") : this.defaultColor;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        if (stack.m_41763_() && stack.m_41776_() <= stack.m_41773_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.paraglider.paraglider_broken").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.m_41720_() != newStack.m_41720_() || ParagliderItem.isItemParagliding(oldStack) != ParagliderItem.isItemParagliding(newStack);
    }

    public static boolean isItemParagliding(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_("Paragliding");
    }

    public static void setItemParagliding(ItemStack stack, boolean paragliding) {
        if (ParagliderItem.isItemParagliding(stack) == paragliding) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (paragliding) {
            tag.m_128379_("Paragliding", true);
        } else {
            tag.m_128473_("Paragliding");
        }
    }
}

