/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.bargain.preview;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3518;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.api.bargain.DemandPreview;

public record QuantifiedIngredient(@NotNull class_1856 ingredient, @Range(from=0L, to=0x7FFFFFFFL) int quantity) implements Predicate<class_1799>,
DemandPreview
{
    public QuantifiedIngredient(@NotNull class_1856 ingredient, int quantity) {
        this.ingredient = Objects.requireNonNull(ingredient);
        this.quantity = Math.max(0, quantity);
    }

    public QuantifiedIngredient(@NotNull JsonObject obj) {
        this(class_1856.method_52177((JsonElement)obj.get("ingredient")), Math.max(1, class_3518.method_15282((JsonObject)obj, (String)"quantity", (int)1)));
    }

    @NotNull
    public static QuantifiedIngredient read(@NotNull class_2540 buffer) {
        return new QuantifiedIngredient(class_1856.method_8086((class_2540)buffer), buffer.method_10816());
    }

    @Override
    public boolean test(class_1799 itemStack) {
        return this.ingredient.method_8093(itemStack);
    }

    @Override
    @NotNull
    public @NotNull @Unmodifiable List<@NotNull class_1799> preview() {
        return List.of(this.ingredient.method_8105());
    }

    @Override
    public int count(@NotNull class_1657 player) {
        int count = 0;
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7960() || !this.ingredient.method_8093(stack)) continue;
            count += stack.method_7947();
        }
        return count;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull class_2561> getTooltip(int previewIndex) {
        class_1799[] items = this.ingredient.method_8105();
        if (items.length == 0) {
            return List.of();
        }
        class_1799 stack = items[previewIndex < 0 || items.length <= previewIndex ? 0 : previewIndex];
        return class_437.method_25408((class_310)class_310.method_1551(), (class_1799)stack);
    }

    @NotNull
    public JsonElement serialize() {
        JsonObject obj = new JsonObject();
        obj.add("ingredient", this.ingredient.method_8089());
        if (this.quantity != 1) {
            obj.addProperty("quantity", (Number)this.quantity);
        }
        return obj;
    }

    public void write(@NotNull class_2540 buffer) {
        this.ingredient.method_8088(buffer);
        buffer.method_10804(this.quantity);
    }
}

