/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.bargain.preview.QuantifiedIngredient;
import tictim.paraglider.bargain.preview.QuantifiedItem;
import tictim.paraglider.contents.recipe.SimpleBargain;

public abstract class SimpleBargainSerializer<T extends SimpleBargain>
implements class_1865<T> {
    @NotNull
    public T fromJson(@NotNull class_2960 recipeId, @NotNull JsonObject json) {
        ObjectOpenHashSet userTags;
        int essenceOffers;
        int staminaVesselOffers;
        int heartContainerOffers;
        List<QuantifiedItem> itemOffers;
        int essenceDemands;
        int staminaVesselDemands;
        int heartContainerDemands;
        List<QuantifiedIngredient> itemDemands;
        class_2960 bargainType = new class_2960(json.has("bargainType") ? class_3518.method_15265((JsonObject)json, (String)"bargainType") : (json.has("owner") ? class_3518.method_15265((JsonObject)json, (String)"owner") : class_3518.method_15265((JsonObject)json, (String)"bargainType")));
        JsonObject demands = class_3518.method_15281((JsonObject)json, (String)"demands", null);
        if (demands != null) {
            JsonArray items = class_3518.method_15292((JsonObject)demands, (String)"items", null);
            if (items == null || items.isEmpty()) {
                itemDemands = Collections.emptyList();
            } else {
                itemDemands = new ArrayList();
                for (JsonElement i : items) {
                    itemDemands.add(new QuantifiedIngredient(class_3518.method_15295((JsonElement)i, (String)"item")));
                }
            }
            heartContainerDemands = Math.max(0, class_3518.method_15282((JsonObject)demands, (String)"heartContainers", (int)0));
            staminaVesselDemands = Math.max(0, class_3518.method_15282((JsonObject)demands, (String)"staminaVessels", (int)0));
            essenceDemands = Math.max(0, class_3518.method_15282((JsonObject)demands, (String)"essences", (int)0));
        } else {
            itemDemands = Collections.emptyList();
            heartContainerDemands = 0;
            staminaVesselDemands = 0;
            essenceDemands = 0;
        }
        JsonObject offers = class_3518.method_15281((JsonObject)json, (String)"offers", null);
        if (offers != null) {
            JsonArray items = class_3518.method_15292((JsonObject)offers, (String)"items", null);
            if (items == null || items.isEmpty()) {
                itemOffers = Collections.emptyList();
            } else {
                itemOffers = new ArrayList();
                for (JsonElement i : items) {
                    class_1799 stack = class_1869.method_35228((JsonObject)class_3518.method_15295((JsonElement)i, (String)"item"));
                    itemOffers.add(new QuantifiedItem(stack.method_7909(), stack.method_7947()));
                }
            }
            heartContainerOffers = Math.max(0, class_3518.method_15282((JsonObject)offers, (String)"heartContainers", (int)0));
            staminaVesselOffers = Math.max(0, class_3518.method_15282((JsonObject)offers, (String)"staminaVessels", (int)0));
            essenceOffers = Math.max(0, class_3518.method_15282((JsonObject)offers, (String)"essences", (int)0));
        } else {
            itemOffers = Collections.emptyList();
            heartContainerOffers = 0;
            staminaVesselOffers = 0;
            essenceOffers = 0;
        }
        JsonArray tags = class_3518.method_15292((JsonObject)json, (String)"tags", null);
        if (tags != null) {
            userTags = new ObjectOpenHashSet();
            for (JsonElement tag : tags) {
                userTags.add(class_3518.method_15287((JsonElement)tag, (String)"tag"));
            }
        } else {
            userTags = Collections.emptySet();
        }
        return this.instantiate(recipeId, json, bargainType, itemDemands, heartContainerDemands, staminaVesselDemands, essenceDemands, itemOffers, heartContainerOffers, staminaVesselOffers, essenceOffers, (Set<String>)userTags);
    }

    @NotNull
    protected abstract T instantiate(@NotNull class_2960 var1, @NotNull JsonObject var2, @NotNull class_2960 var3, @NotNull @NotNull List<@NotNull QuantifiedIngredient> var4, int var5, int var6, int var7, @NotNull @NotNull List<@NotNull QuantifiedItem> var8, int var9, int var10, int var11, @NotNull @NotNull Set<@NotNull String> var12);

    @NotNull
    public T fromNetwork(@NotNull class_2960 recipeId, @NotNull class_2540 buffer) {
        class_2960 bargainType = buffer.method_10810();
        ArrayList<QuantifiedIngredient> itemDemands = new ArrayList<QuantifiedIngredient>();
        int size = buffer.method_10816();
        for (int i = 0; i < size; ++i) {
            itemDemands.add(QuantifiedIngredient.read(buffer));
        }
        int heartContainerDemands = buffer.method_10816();
        int staminaVesselDemands = buffer.method_10816();
        int essenceDemands = buffer.method_10816();
        ArrayList<QuantifiedItem> itemOffers = new ArrayList<QuantifiedItem>();
        int size2 = buffer.method_10816();
        for (int i = 0; i < size2; ++i) {
            itemOffers.add(QuantifiedItem.read(buffer));
        }
        int heartContainerOffers = buffer.method_10816();
        int staminaVesselOffers = buffer.method_10816();
        int essenceOffers = buffer.method_10816();
        ObjectOpenHashSet userTags = new ObjectOpenHashSet();
        int size3 = buffer.method_10816();
        for (int i = 0; i < size3; ++i) {
            userTags.add(buffer.method_19772());
        }
        return this.instantiate(recipeId, buffer, bargainType, itemDemands, heartContainerDemands, staminaVesselDemands, essenceDemands, itemOffers, heartContainerOffers, staminaVesselOffers, essenceOffers, (Set<String>)userTags);
    }

    @NotNull
    protected abstract T instantiate(@NotNull class_2960 var1, @NotNull class_2540 var2, @NotNull class_2960 var3, @NotNull @NotNull List<@NotNull QuantifiedIngredient> var4, int var5, int var6, int var7, @NotNull @NotNull List<@NotNull QuantifiedItem> var8, int var9, int var10, int var11, @NotNull @NotNull Set<@NotNull String> var12);

    public void toNetwork(@NotNull class_2540 buffer, @NotNull T recipe) {
        buffer.method_10812(((SimpleBargain)recipe).getBargainType());
        List<QuantifiedIngredient> itemDemands = ((SimpleBargain)recipe).getItemDemands();
        buffer.method_10804(itemDemands.size());
        for (QuantifiedIngredient quantifiedIngredient : itemDemands) {
            quantifiedIngredient.write(buffer);
        }
        buffer.method_10804(((SimpleBargain)recipe).getHeartContainerDemands());
        buffer.method_10804(((SimpleBargain)recipe).getStaminaVesselDemands());
        buffer.method_10804(((SimpleBargain)recipe).getEssenceDemands());
        List<QuantifiedItem> itemOffers = ((SimpleBargain)recipe).getItemOffers();
        buffer.method_10804(itemOffers.size());
        for (QuantifiedItem offer : itemOffers) {
            offer.write(buffer);
        }
        buffer.method_10804(((SimpleBargain)recipe).getHeartContainerOffers());
        buffer.method_10804(((SimpleBargain)recipe).getStaminaVesselOffers());
        buffer.method_10804(((SimpleBargain)recipe).getEssenceOffers());
        Set<String> set = ((SimpleBargain)recipe).getUserTags();
        buffer.method_10804(set.size());
        for (String userTag : set) {
            buffer.method_10814(userTag);
        }
    }

    public static final class Simple
    extends SimpleBargainSerializer<SimpleBargain> {
        @Override
        @NotNull
        protected SimpleBargain instantiate(@NotNull class_2960 recipeId, @NotNull JsonObject json, @NotNull class_2960 bargainType, @NotNull @NotNull List<@NotNull QuantifiedIngredient> itemDemands, int heartContainerDemands, int staminaVesselDemands, int essenceDemands, @NotNull @NotNull List<@NotNull QuantifiedItem> itemOffers, int heartContainerOffers, int staminaVesselOffers, int essenceOffers, @NotNull @NotNull Set<@NotNull String> userTags) {
            return new SimpleBargain(recipeId, bargainType, itemDemands, heartContainerDemands, staminaVesselDemands, essenceDemands, itemOffers, heartContainerOffers, staminaVesselOffers, essenceOffers, userTags);
        }

        @Override
        @NotNull
        protected SimpleBargain instantiate(@NotNull class_2960 recipeId, @NotNull class_2540 buffer, @NotNull class_2960 bargainType, @NotNull @NotNull List<@NotNull QuantifiedIngredient> itemDemands, int heartContainerDemands, int staminaVesselDemands, int essenceDemands, @NotNull @NotNull List<@NotNull QuantifiedItem> itemOffers, int heartContainerOffers, int staminaVesselOffers, int essenceOffers, @NotNull @NotNull Set<@NotNull String> userTags) {
            return new SimpleBargain(recipeId, bargainType, itemDemands, heartContainerDemands, staminaVesselDemands, essenceDemands, itemOffers, heartContainerOffers, staminaVesselOffers, essenceOffers, userTags);
        }
    }
}

