/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.fabric;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.api.movement.MovementPlugin;
import tictim.paraglider.api.plugin.ParagliderPluginBase;
import tictim.paraglider.api.plugin.PluginInstance;
import tictim.paraglider.api.stamina.StaminaPlugin;
import tictim.paraglider.plugin.ParagliderPluginLoader;

public final class FabricParagliderPluginLoader
implements ParagliderPluginLoader {
    private static final FabricParagliderPluginLoader instance = new FabricParagliderPluginLoader();
    private static final Class<?>[] allPluginTypes = new Class[]{StaminaPlugin.class, MovementPlugin.class};
    private boolean initialized;
    private final List<PluginInstance<StaminaPlugin>> staminaPlugins = new ArrayList<PluginInstance<StaminaPlugin>>();
    private final List<PluginInstance<MovementPlugin>> movementPlugins = new ArrayList<PluginInstance<MovementPlugin>>();

    private FabricParagliderPluginLoader() {
    }

    @NotNull
    public static FabricParagliderPluginLoader get() {
        return instance;
    }

    @Override
    @NotNull
    public @NotNull @Unmodifiable List<@NotNull PluginInstance<StaminaPlugin>> getStaminaPlugins() {
        this.checkAndInitialize();
        return Collections.unmodifiableList(this.staminaPlugins);
    }

    @Override
    @NotNull
    public @NotNull @Unmodifiable List<@NotNull PluginInstance<MovementPlugin>> getMovementPlugins() {
        this.checkAndInitialize();
        return Collections.unmodifiableList(this.movementPlugins);
    }

    private void checkAndInitialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        ArrayList<PluginInstance<ParagliderPluginBase>> plugins = new ArrayList<PluginInstance<ParagliderPluginBase>>();
        List containers = FabricLoader.getInstance().getEntrypointContainers("paraglider-plugin", ParagliderPluginBase.class);
        for (EntrypointContainer entrypointContainer : containers) {
            if (!FabricParagliderPluginLoader.checkPluginType((ParagliderPluginBase)entrypointContainer.getEntrypoint())) {
                ParagliderMod.LOGGER.debug("Plugin {} doesn't implement any of the available plugin types; available plugin types are:\n  {}", entrypointContainer.getEntrypoint(), (Object)Arrays.stream(allPluginTypes).map(c -> c.getCanonicalName()).collect(Collectors.joining("\n  ")));
                continue;
            }
            String modID = entrypointContainer.getProvider().getMetadata().getId();
            plugins.add(new PluginInstance<ParagliderPluginBase>((ParagliderPluginBase)entrypointContainer.getEntrypoint(), modID));
            ParagliderMod.LOGGER.debug("Loaded plugin {} associated with mod {}", ((ParagliderPluginBase)entrypointContainer.getEntrypoint()).getClass(), (Object)modID);
        }
        ParagliderMod.LOGGER.debug("Loaded {} plugins total", (Object)plugins.size());
        for (PluginInstance pluginInstance : plugins) {
            if (pluginInstance.instance() instanceof StaminaPlugin) {
                this.staminaPlugins.add(pluginInstance.cast(StaminaPlugin.class));
            }
            if (!(pluginInstance.instance() instanceof MovementPlugin)) continue;
            this.movementPlugins.add(pluginInstance.cast(MovementPlugin.class));
        }
    }

    private static boolean checkPluginType(@NotNull ParagliderPluginBase instance) {
        for (Class<?> c : allPluginTypes) {
            if (!c.isInstance(instance)) continue;
            return true;
        }
        return false;
    }
}

