/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.movement;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.api.movement.ParagliderPlayerStates;
import tictim.paraglider.api.movement.PlayerState;
import tictim.paraglider.impl.movement.SimplePlayerState;

public final class PlayerStateMap {
    private final Map<class_2960, PlayerState> states;
    @Nullable
    private Boolean hasStaminaConsumptionCache = null;

    public PlayerStateMap(@NotNull @NotNull Map<@NotNull class_2960, @NotNull PlayerState> states) {
        this.states = Objects.requireNonNull(states);
    }

    @NotNull
    public static PlayerStateMap read(@NotNull class_2540 buffer) {
        Object2ObjectOpenHashMap states = new Object2ObjectOpenHashMap();
        int count = buffer.method_10816();
        for (int i = 0; i < count; ++i) {
            SimplePlayerState state = SimplePlayerState.read(buffer);
            states.put(state.id(), state);
        }
        if (!states.containsKey(ParagliderPlayerStates.IDLE)) {
            ParagliderMod.LOGGER.error("Instance of PlayerStateMap constructed from packet does not have idle state, something is wrong!");
            states.put(ParagliderPlayerStates.IDLE, new SimplePlayerState(ParagliderPlayerStates.IDLE, Set.of(), 20, 0));
        }
        return new PlayerStateMap((Map<class_2960, PlayerState>)states);
    }

    @NotNull
    public @NotNull @Unmodifiable Map<@NotNull class_2960, @NotNull PlayerState> states() {
        return Collections.unmodifiableMap(this.states);
    }

    @NotNull
    public PlayerState expectState(@NotNull class_2960 id) {
        PlayerState state = this.getState(id);
        if (state == null) {
            throw new NoSuchElementException("No state named " + id + " in state map");
        }
        return state;
    }

    @Nullable
    public PlayerState getState(@NotNull class_2960 id) {
        return this.states.get(id);
    }

    @NotNull
    public PlayerState getIdleState() {
        return this.expectState(ParagliderPlayerStates.IDLE);
    }

    public boolean hasStaminaConsumption() {
        if (this.hasStaminaConsumptionCache != null) {
            return this.hasStaminaConsumptionCache;
        }
        this.hasStaminaConsumptionCache = this.states.values().stream().anyMatch(s -> s.staminaDelta() > 0);
        return this.hasStaminaConsumptionCache;
    }

    public void write(@NotNull class_2540 buffer) {
        buffer.method_10804(this.states.size());
        for (PlayerState state : this.states.values()) {
            SimplePlayerState.write(buffer, state);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PlayerStateMap)) {
            return false;
        }
        PlayerStateMap stateMap = (PlayerStateMap)obj;
        return this.states.equals(stateMap.states);
    }

    public int hashCode() {
        return Objects.hash(this.states);
    }

    public String toString() {
        return "PlayerStateMap{states=" + this.states + "}";
    }
}

