/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.vessel;

import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.api.Copy;
import tictim.paraglider.api.Serde;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.config.Cfg;

public class SimpleVesselContainer
implements VesselContainer,
Serde,
Copy {
    protected final class_1657 player;
    protected int heartContainer;
    protected int staminaVessel;
    protected int essence;

    public SimpleVesselContainer(@Nullable class_1657 player) {
        this.player = player;
    }

    @Override
    public final int heartContainer() {
        return this.heartContainer;
    }

    @Override
    public final int staminaVessel() {
        return this.staminaVessel;
    }

    @Override
    public final int essence() {
        return this.essence;
    }

    @Override
    @NotNull
    public VesselContainer.SetResult setHeartContainer(int amount, boolean simulate, boolean playEffect) {
        if (amount < 0) {
            return VesselContainer.SetResult.TOO_LOW;
        }
        if (amount > Cfg.get().maxHeartContainers()) {
            return VesselContainer.SetResult.TOO_HIGH;
        }
        int change = amount - this.heartContainer;
        if (change == 0) {
            return VesselContainer.SetResult.NO_CHANGE;
        }
        if (!simulate) {
            this.heartContainer = amount;
            this.onChange(ActionType.HEART_CONTAINER, change);
            if (playEffect) {
                this.playEffect(ActionType.HEART_CONTAINER, change);
            }
        }
        return VesselContainer.SetResult.OK;
    }

    @Override
    @NotNull
    public VesselContainer.SetResult setStaminaVessel(int amount, boolean simulate, boolean playEffect) {
        if (amount < 0) {
            return VesselContainer.SetResult.TOO_LOW;
        }
        if (amount > Cfg.get().maxStaminaVessels()) {
            return VesselContainer.SetResult.TOO_HIGH;
        }
        int change = amount - this.staminaVessel;
        if (change == 0) {
            return VesselContainer.SetResult.NO_CHANGE;
        }
        if (!simulate) {
            this.staminaVessel = amount;
            this.onChange(ActionType.STAMINA_VESSEL, change);
            if (playEffect) {
                this.playEffect(ActionType.STAMINA_VESSEL, change);
            }
        }
        return VesselContainer.SetResult.OK;
    }

    @Override
    @NotNull
    public VesselContainer.SetResult setEssence(int amount, boolean simulate, boolean playEffect) {
        if (amount < 0) {
            return VesselContainer.SetResult.TOO_LOW;
        }
        int change = amount - this.essence;
        if (change == 0) {
            return VesselContainer.SetResult.NO_CHANGE;
        }
        if (!simulate) {
            this.essence = amount;
            this.onChange(ActionType.ESSENCE, change);
            if (playEffect) {
                this.playEffect(ActionType.ESSENCE, change);
            }
        }
        return VesselContainer.SetResult.OK;
    }

    @Override
    public int giveHeartContainers(int amount, boolean simulate, boolean playEffect) {
        if ((amount = Math.min(amount, Cfg.get().maxHeartContainers() - this.heartContainer)) <= 0) {
            return 0;
        }
        if (!simulate) {
            this.heartContainer += amount;
            this.onChange(ActionType.HEART_CONTAINER, amount);
            if (playEffect) {
                this.playEffect(ActionType.HEART_CONTAINER, amount);
            }
        }
        return amount;
    }

    @Override
    public int giveStaminaVessels(int amount, boolean simulate, boolean playEffect) {
        if ((amount = Math.min(amount, Cfg.get().maxStaminaVessels() - this.staminaVessel)) <= 0) {
            return 0;
        }
        if (!simulate) {
            this.staminaVessel += amount;
            this.onChange(ActionType.STAMINA_VESSEL, amount);
            if (playEffect) {
                this.playEffect(ActionType.STAMINA_VESSEL, amount);
            }
        }
        return amount;
    }

    @Override
    public int giveEssences(int amount, boolean simulate, boolean playEffect) {
        if ((amount = Math.min(amount, Integer.MAX_VALUE - this.essence)) <= 0) {
            return 0;
        }
        if (!simulate) {
            this.essence += amount;
            this.onChange(ActionType.ESSENCE, amount);
            if (playEffect) {
                this.playEffect(ActionType.ESSENCE, amount);
            }
        }
        return amount;
    }

    @Override
    public int takeHeartContainers(int amount, boolean simulate, boolean playEffect) {
        if ((amount = Math.min(amount, this.heartContainer)) <= 0) {
            return 0;
        }
        if (!simulate) {
            this.heartContainer -= amount;
            this.onChange(ActionType.HEART_CONTAINER, -amount);
            if (playEffect) {
                this.playEffect(ActionType.HEART_CONTAINER, -amount);
            }
        }
        return amount;
    }

    @Override
    public int takeStaminaVessels(int amount, boolean simulate, boolean playEffect) {
        if ((amount = Math.min(amount, this.staminaVessel)) <= 0) {
            return 0;
        }
        if (!simulate) {
            this.staminaVessel -= amount;
            this.onChange(ActionType.STAMINA_VESSEL, -amount);
            if (playEffect) {
                this.playEffect(ActionType.STAMINA_VESSEL, -amount);
            }
        }
        return amount;
    }

    @Override
    public int takeEssences(int amount, boolean simulate, boolean playEffect) {
        if ((amount = Math.min(amount, this.essence)) <= 0) {
            return 0;
        }
        if (!simulate) {
            this.essence -= amount;
            this.onChange(ActionType.ESSENCE, -amount);
            if (playEffect) {
                this.playEffect(ActionType.ESSENCE, -amount);
            }
        }
        return amount;
    }

    @Override
    public void copyFrom(@NotNull Object from) {
        if (!(from instanceof VesselContainer)) {
            return;
        }
        VesselContainer vessels = (VesselContainer)from;
        this.setHeartContainer(vessels.heartContainer(), false, false);
        this.setStaminaVessel(vessels.staminaVessel(), false, false);
        this.setEssence(vessels.essence(), false, false);
    }

    protected void onChange(@NotNull ActionType actionType, int change) {
    }

    protected void playEffect(@NotNull ActionType actionType, int change) {
        if (change > 0) {
            switch (actionType) {
                case HEART_CONTAINER: {
                    this.spawnParticle((class_2394)class_2398.field_11201, 5 + 5 * change);
                    break;
                }
                case STAMINA_VESSEL: {
                    this.spawnParticle((class_2394)class_2398.field_11211, 7 + 7 * change);
                }
            }
        }
    }

    protected void spawnParticle(@NotNull class_2394 particle, int count) {
        class_1937 class_19372;
        if (this.player != null && (class_19372 = this.player.method_37908()) instanceof class_3218) {
            class_3218 sl = (class_3218)class_19372;
            sl.method_14199(particle, this.player.method_23317(), this.player.method_23323(0.5), this.player.method_23321(), count, 1.0, 2.0, 1.0, 0.0);
        }
    }

    @Override
    @NotNull
    public class_2487 write() {
        class_2487 tag = new class_2487();
        tag.method_10569("heartContainers", this.heartContainer);
        tag.method_10569("staminaVessels", this.staminaVessel);
        tag.method_10569("essences", this.essence);
        return tag;
    }

    @Override
    public void read(@NotNull class_2487 tag) {
        this.heartContainer = tag.method_10550("heartContainers");
        this.staminaVessel = tag.method_10550("staminaVessels");
        this.essence = tag.method_10550("essences");
    }

    public String toString() {
        return "SimpleVesselContainer{heartContainer=" + this.heartContainer + ", staminaVessel=" + this.staminaVessel + ", essence=" + this.essence + "}";
    }

    public static enum ActionType {
        HEART_CONTAINER,
        STAMINA_VESSEL,
        ESSENCE;

    }
}

