/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.network;

import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.api.movement.Movement;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.client.screen.BargainScreen;
import tictim.paraglider.network.Kind;
import tictim.paraglider.network.SyncMovementHandle;
import tictim.paraglider.network.message.BargainDialogMsg;
import tictim.paraglider.network.message.BargainEndMsg;
import tictim.paraglider.network.message.BargainInitMsg;
import tictim.paraglider.network.message.Msg;
import tictim.paraglider.network.message.SyncCatalogMsg;
import tictim.paraglider.network.message.SyncLookAtMsg;
import tictim.paraglider.network.message.SyncMovementMsg;
import tictim.paraglider.network.message.SyncPlayerStateMapMsg;
import tictim.paraglider.network.message.SyncRemoteMovementMsg;
import tictim.paraglider.network.message.SyncVesselMsg;
import tictim.paraglider.network.message.SyncWindMsg;
import tictim.paraglider.wind.Wind;

public final class ClientPacketHandler {
    private ClientPacketHandler() {
    }

    public static void handleSyncPlayerStateMap(SyncPlayerStateMapMsg msg) {
        ClientPacketHandler.trace(Kind.MOVEMENT, msg);
        ParagliderMod.instance().setSyncedPlayerStateMap(msg.stateMap());
    }

    public static void handleSyncMovement(SyncMovementMsg msg) {
        ClientPacketHandler.trace(Kind.MOVEMENT, msg);
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        Movement movement = Movement.get((class_1657)mc.field_1724);
        if (movement instanceof SyncMovementHandle) {
            SyncMovementHandle smh = (SyncMovementHandle)((Object)movement);
            smh.syncMovement(msg.state(), msg.stamina(), msg.depleted(), msg.recoveryDelay(), msg.reductionRate());
        }
    }

    public static void handleSyncRemoteMovement(SyncRemoteMovementMsg msg) {
        ClientPacketHandler.trace(Kind.MOVEMENT, msg);
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        class_1657 player = mc.field_1687.method_18470(msg.entityId());
        if (player == null) {
            return;
        }
        Movement movement = Movement.get(player);
        if (movement instanceof SyncMovementHandle) {
            SyncMovementHandle smh = (SyncMovementHandle)((Object)movement);
            smh.syncRemoteMovement(msg.state());
        }
    }

    public static void handleSyncVessel(SyncVesselMsg msg) {
        ClientPacketHandler.trace(Kind.VESSEL, msg);
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        VesselContainer vessels = VesselContainer.get((class_1657)mc.field_1724);
        vessels.setHeartContainer(msg.heartContainers(), false, false);
        vessels.setStaminaVessel(msg.staminaVessels(), false, false);
        Stamina.get((class_1657)mc.field_1724).setStamina(msg.stamina());
    }

    public static void handleBargainInit(BargainInitMsg msg) {
        ClientPacketHandler.trace(Kind.BARGAIN, msg);
        class_310 mc = class_310.method_1551();
        mc.method_1507((class_437)new BargainScreen(msg.sessionId(), msg.catalog(), msg.lookAt(), msg.dialog()));
    }

    public static void handleSyncCatalog(SyncCatalogMsg msg) {
        ClientPacketHandler.trace(Kind.BARGAIN, msg);
        class_310 mc = class_310.method_1551();
        class_437 class_4372 = mc.field_1755;
        if (class_4372 instanceof BargainScreen) {
            BargainScreen bargainScreen = (BargainScreen)class_4372;
            if (bargainScreen.sessionId == msg.sessionId()) {
                bargainScreen.setCatalog(msg.catalog());
            }
        }
    }

    public static void handleSyncLookAt(SyncLookAtMsg msg) {
        ClientPacketHandler.trace(Kind.BARGAIN, msg);
        class_310 mc = class_310.method_1551();
        class_437 class_4372 = mc.field_1755;
        if (class_4372 instanceof BargainScreen) {
            BargainScreen bargainScreen = (BargainScreen)class_4372;
            if (bargainScreen.sessionId == msg.sessionId()) {
                bargainScreen.setLookAt(msg.lookAt());
            }
        }
    }

    public static void handleBargainDialog(BargainDialogMsg msg) {
        ClientPacketHandler.trace(Kind.BARGAIN, msg);
        class_310 mc = class_310.method_1551();
        class_437 class_4372 = mc.field_1755;
        if (class_4372 instanceof BargainScreen) {
            BargainScreen bargainScreen = (BargainScreen)class_4372;
            if (bargainScreen.sessionId == msg.sessionId()) {
                bargainScreen.setDialog(msg.dialog());
            }
        }
    }

    public static void handleBargainEnd(BargainEndMsg msg) {
        ClientPacketHandler.trace(Kind.BARGAIN, msg);
        class_310 mc = class_310.method_1551();
        class_437 class_4372 = mc.field_1755;
        if (class_4372 instanceof BargainScreen) {
            BargainScreen bargainScreen = (BargainScreen)class_4372;
            if (bargainScreen.sessionId == msg.sessionId()) {
                mc.method_1507(null);
            }
        }
    }

    public static void handleSyncWind(SyncWindMsg msg) {
        ClientPacketHandler.trace(Kind.WIND, msg);
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        Wind wind = Wind.of((class_1936)world);
        if (wind != null) {
            wind.put(msg.windChunk());
        }
    }

    private static void trace(@NotNull Kind kind, @NotNull Msg msg) {
        if (kind.isTraceEnabled()) {
            ParagliderMod.LOGGER.debug("Received {} from server", (Object)msg);
        }
    }
}

