/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.piratesandlootersreborn.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.mcreator.piratesandlootersreborn.PiratesandlootersrebornModElements;
import net.mcreator.piratesandlootersreborn.entity.renderer.KrakenRenderer;
import net.mcreator.piratesandlootersreborn.procedures.SwimTestMobNaturalEntitySpawningConditionProcedure;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.network.IPacket;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

@PiratesandlootersrebornModElements.ModElement.Tag
public class KrakenEntity
extends PiratesandlootersrebornModElements.ModElement {
    public static EntityType entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220321_a(3.0f, 25.0f).func_206830_a("kraken").setRegistryName("kraken");

    public KrakenEntity(PiratesandlootersrebornModElements instance) {
        super(instance, 147);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new KrakenRenderer.ModelRegisterHandler());
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new EntityAttributesRegisterHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> entity);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -16764058, -16751002, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName("kraken_spawn_egg"));
    }

    @SubscribeEvent
    public void addFeatureToBiomes(BiomeLoadingEvent event) {
        event.getSpawns().getSpawner(EntityClassification.WATER_CREATURE).add(new MobSpawnInfo.Spawners(entity, 100, 4, 4));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            return SwimTestMobNaturalEntitySpawningConditionProcedure.executeProcedure((Map<String, Object>)ImmutableMap.of((Object)"x", (Object)x, (Object)"y", (Object)y, (Object)"z", (Object)z, (Object)"world", (Object)world));
        });
    }

    public static class CustomEntity
    extends MonsterEntity {
        private int attackTimer;
        private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS);

        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.func_184644_a(PathNodeType.WATER, 0.0f);
            this.field_70728_aV = 0;
            this.field_70138_W = 4.0f;
            this.func_94061_f(false);
            this.func_110163_bv();
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        public void func_70619_bc() {
            super.func_70619_bc();
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, false, false));
            this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2, false));
            this.field_70714_bg.func_75776_a(3, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
            this.field_70714_bg.func_75776_a(4, (Goal)new TailSwip());
            this.field_70714_bg.func_75776_a(4, (Goal)new AttackGoal());
            this.field_70714_bg.func_75776_a(4, (Goal)new Swimming());
            this.field_70714_bg.func_75776_a(4, (Goal)new Bite());
            this.field_70715_bh.func_75776_a(4, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
            this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(6, (Goal)new SwimGoal((MobEntity)this));
        }

        protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
            return 5.6f;
        }

        protected float func_70647_i() {
            return 0.5f;
        }

        protected float func_70599_aP() {
            return 3.5f;
        }

        public void func_70636_d() {
            super.func_70636_d();
            if (this.attackTimer > 0) {
                --this.attackTimer;
            }
        }

        public boolean func_70652_k(Entity entityIn) {
            return false;
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_70103_a(byte id) {
            if (id == 4) {
                this.attackTimer = 10;
            }
            super.func_70103_a(id);
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source == DamageSource.field_76379_h) {
                return false;
            }
            if (source == DamageSource.field_76368_d) {
                return false;
            }
            if (source == DamageSource.field_76369_e) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getAttackTimer() {
            return this.attackTimer;
        }

        public boolean func_213397_c(double distanceToClosestPlayer) {
            return false;
        }

        public SoundEvent func_184639_G() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("piratesandlootersreborn:kraken_say"));
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("piratesandlootersreborn:kraken_hit"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("piratesandlootersreborn:kraken_death"));
        }

        public boolean func_70648_aU() {
            return true;
        }

        public boolean func_184222_aU() {
            return false;
        }

        public void func_184178_b(ServerPlayerEntity player) {
            super.func_184178_b(player);
            this.bossInfo.func_186760_a(player);
        }

        public void func_184203_c(ServerPlayerEntity player) {
            super.func_184203_c(player);
            this.bossInfo.func_186761_b(player);
        }

        class Swimming
        extends Goal {
            public boolean func_75250_a() {
                return CustomEntity.this.func_70089_S() && (CustomEntity.this.func_180799_ab() || CustomEntity.this.func_70090_H());
            }

            public void func_75246_d() {
                CustomEntity entity = CustomEntity.this;
                float surfaceIndicator = CustomEntity.this.field_70170_p.func_201676_a(Heightmap.Type.OCEAN_FLOOR, (int)CustomEntity.this.func_226277_ct_(), (int)CustomEntity.this.func_226281_cx_());
                float verticalSpeed = CustomEntity.this.func_226278_cu_() - 6.0 < (double)surfaceIndicator ? 0.4f : -0.4f;
                float speed = (float)entity.func_233637_b_(Attributes.field_233821_d_);
                if (((MobEntity)entity).func_213398_dR()) {
                    entity.func_213317_d(entity.func_213322_ci().func_72441_c((double)speed * Math.sin(-1.0 * Math.toRadians(((LivingEntity)entity).field_70177_z)) / 6.0, (double)speed * (Math.sin(-1.0 * Math.toRadians(((LivingEntity)entity).field_70125_A)) / 2.0 + (double)0.1f), (double)speed * Math.cos(-1.0 * Math.toRadians(((LivingEntity)entity).field_70177_z)) / 6.0));
                } else {
                    entity.func_213317_d(entity.func_213322_ci().func_72441_c((double)speed * Math.sin(-1.0 * Math.toRadians(((LivingEntity)entity).field_70177_z)) / 6.0, (double)speed * (Math.sin(-1.0 * Math.toRadians(((LivingEntity)entity).field_70125_A)) / 2.0 + (double)verticalSpeed), (double)speed * Math.cos(-1.0 * Math.toRadians(((LivingEntity)entity).field_70177_z)) / 6.0));
                }
                ((LivingEntity)entity).field_70177_z = entity.func_195046_g(1.0f);
                super.func_75246_d();
            }
        }

        class AttackGoal
        extends Goal {
            public AttackGoal() {
                this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
            }

            public boolean func_75250_a() {
                LivingEntity livingentity = CustomEntity.this.func_70638_az();
                return livingentity != null && livingentity.func_70089_S();
            }

            public void func_75246_d() {
                LivingEntity livingentity = CustomEntity.this.func_70638_az();
                CustomEntity.this.func_70671_ap().func_75651_a((Entity)livingentity, 5.0f, 5.0f);
                CustomEntity.this.field_70177_z = CustomEntity.this.func_195046_g(1.0f);
                super.func_75246_d();
            }
        }

        class Bite
        extends Goal {
            private int coolTime;
            private int biteCount;

            public boolean func_75250_a() {
                LivingEntity livingentity = CustomEntity.this.func_70638_az();
                if (livingentity != null && livingentity.func_70089_S()) {
                    return true;
                }
                if ((float)CustomEntity.this.func_233637_b_(Attributes.field_233830_m_) == 1.0f) {
                    CustomEntity.this.func_110148_a(Attributes.field_233830_m_).func_111128_a(0.0);
                }
                return false;
            }

            public void func_75246_d() {
                double x = CustomEntity.this.func_226277_ct_();
                double y = CustomEntity.this.func_226278_cu_();
                double z = CustomEntity.this.func_226281_cx_();
                if (this.biteCount == 0) {
                    CustomEntity.this.func_110148_a(Attributes.field_233830_m_).func_111128_a(0.0);
                }
                if (this.coolTime < 55) {
                    ++this.coolTime;
                } else if (this.biteCount > 0) {
                    --this.biteCount;
                    LivingEntity livingentity = CustomEntity.this.func_70638_az();
                    List _entfound = CustomEntity.this.field_70170_p.func_175647_a(Entity.class, new AxisAlignedBB(x - 6.0, y - 6.0, z - 6.0, x + 6.0, y + 6.0, z + 6.0), null).stream().sorted(new Object(){

                        Comparator<Entity> compareDistOf(double _x, double _y, double _z) {
                            return Comparator.comparing(_entcnd -> _entcnd.func_70092_e(_x, _y, _z));
                        }
                    }.compareDistOf(x, y, z)).collect(Collectors.toList());
                    for (Entity entityiterator : _entfound) {
                        if (entityiterator == CustomEntity.this || !(entityiterator instanceof LivingEntity) || CustomEntity.this.func_184191_r(entityiterator)) continue;
                        double tx = ((LivingEntity)entityiterator).func_226277_ct_();
                        double ty = ((LivingEntity)entityiterator).func_226278_cu_();
                        double tz = ((LivingEntity)entityiterator).func_226281_cx_();
                        entityiterator.func_213317_d(entityiterator.func_213322_ci().func_72441_c((x - tx) / 15.0, (y - ty) / 15.0 - (double)0.01f, (z - tz) / 15.0));
                        entityiterator.func_70097_a(DamageSource.func_76358_a((LivingEntity)CustomEntity.this), 2.0f);
                        entityiterator.field_70172_ad = 0;
                        CustomEntity.this.func_70606_j(CustomEntity.this.func_110143_aJ() + 1.0f);
                        CustomEntity.this.field_70170_p.func_217379_c(2001, new BlockPos((int)tx, (int)ty, (int)tz), Block.func_196246_j((BlockState)Blocks.field_150451_bX.func_176223_P()));
                    }
                    CustomEntity.this.field_70170_p.func_217379_c(2001, new BlockPos((int)x, (int)y, (int)z), Block.func_196246_j((BlockState)Blocks.field_150451_bX.func_176223_P()));
                    CustomEntity.this.func_110148_a(Attributes.field_233830_m_).func_111128_a(1.0);
                    CustomEntity.this.func_184185_a(SoundEvents.field_187537_bA, 3.0f, 0.5f);
                } else {
                    LivingEntity livingentity = CustomEntity.this.func_70638_az();
                    List _entfound = CustomEntity.this.field_70170_p.func_175647_a(Entity.class, new AxisAlignedBB(x - 6.0, y - 6.0, z - 6.0, x + 6.0, y + 6.0, z + 6.0), null).stream().sorted(new Object(){

                        Comparator<Entity> compareDistOf(double _x, double _y, double _z) {
                            return Comparator.comparing(_entcnd -> _entcnd.func_70092_e(_x, _y, _z));
                        }
                    }.compareDistOf(x, y, z)).collect(Collectors.toList());
                    for (Entity entityiterator : _entfound) {
                        if (entityiterator == CustomEntity.this || !(entityiterator instanceof LivingEntity) || CustomEntity.this.func_184191_r(entityiterator)) continue;
                        double tx = ((LivingEntity)entityiterator).func_226277_ct_();
                        double ty = ((LivingEntity)entityiterator).func_226278_cu_();
                        double tz = ((LivingEntity)entityiterator).func_226281_cx_();
                        entityiterator.func_213317_d(entityiterator.func_213322_ci().func_72441_c((x - tx) / 5.0, (y - ty) / 5.0, (z - tz) / 5.0));
                        this.biteCount = 15;
                    }
                    this.coolTime = 0;
                }
            }
        }

        class TailSwip
        extends Goal {
            private int coolTime;

            public boolean func_75250_a() {
                LivingEntity livingentity = CustomEntity.this.func_70638_az();
                return livingentity != null && livingentity.func_70089_S();
            }

            public void func_75246_d() {
                double x = CustomEntity.this.func_226277_ct_();
                double y = CustomEntity.this.func_226278_cu_();
                double z = CustomEntity.this.func_226281_cx_();
                if (this.coolTime < 30) {
                    ++this.coolTime;
                } else {
                    LivingEntity livingentity = CustomEntity.this.func_70638_az();
                    List _entfound = CustomEntity.this.field_70170_p.func_175647_a(Entity.class, new AxisAlignedBB(x - 11.0, y - 11.0, z - 11.0, x + 11.0, y + 11.0, z + 11.0), null).stream().sorted(new Object(){

                        Comparator<Entity> compareDistOf(double _x, double _y, double _z) {
                            return Comparator.comparing(_entcnd -> _entcnd.func_70092_e(_x, _y, _z));
                        }
                    }.compareDistOf(x, y, z)).collect(Collectors.toList());
                    for (Entity entityiterator : _entfound) {
                        if (entityiterator != livingentity) continue;
                        CustomEntity.this.func_184185_a(SoundEvents.field_187730_dW, 2.0f, 0.5f);
                        entityiterator.func_70097_a(DamageSource.func_76358_a((LivingEntity)CustomEntity.this), 8.0f);
                        entityiterator.func_213317_d(entityiterator.func_213322_ci().func_72441_c(0.0, (double)0.4f, 0.0));
                        CustomEntity.this.attackTimer = 10;
                        CustomEntity.this.field_70170_p.func_72960_a((Entity)CustomEntity.this, (byte)4);
                        entityiterator.field_70172_ad = 0;
                        double tx = ((LivingEntity)entityiterator).func_226277_ct_();
                        double ty = ((LivingEntity)entityiterator).func_226278_cu_();
                        double tz = ((LivingEntity)entityiterator).func_226281_cx_();
                        List _entfound2 = CustomEntity.this.field_70170_p.func_175647_a(Entity.class, new AxisAlignedBB(tx - 2.0, ty - 2.0, tz - 2.0, tx + 2.0, ty + 21.0, tz + 2.0), null).stream().sorted(new Object(){

                            Comparator<Entity> compareDistOf(double _x, double _y, double _z) {
                                return Comparator.comparing(_entcnd -> _entcnd.func_70092_e(_x, _y, _z));
                            }
                        }.compareDistOf(x, y, z)).collect(Collectors.toList());
                        for (Entity entityiterator2 : _entfound2) {
                            if (entityiterator2 == CustomEntity.this || !(entityiterator2 instanceof LivingEntity) || CustomEntity.this.func_184191_r(entityiterator2)) continue;
                            entityiterator2.func_70097_a(DamageSource.func_76358_a((LivingEntity)CustomEntity.this), 8.0f);
                            entityiterator2.func_213317_d(entityiterator.func_213322_ci().func_72441_c(0.0, (double)0.8f, 0.0));
                        }
                    }
                    this.coolTime = 0;
                }
            }
        }
    }

    private static class EntityAttributesRegisterHandler {
        private EntityAttributesRegisterHandler() {
        }

        @SubscribeEvent
        public void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
            AttributeModifierMap.MutableAttribute ammma = MobEntity.func_233666_p_();
            ammma = ammma.func_233815_a_(Attributes.field_233821_d_, 0.5);
            ammma = ammma.func_233815_a_(Attributes.field_233818_a_, 650.0);
            ammma = ammma.func_233815_a_(Attributes.field_233824_g_, 6.0);
            ammma = ammma.func_233815_a_(Attributes.field_233830_m_, 0.0);
            ammma = ammma.func_233815_a_(Attributes.field_233826_i_, 0.0);
            ammma = ammma.func_233815_a_(Attributes.field_233819_b_, 100.0);
            ammma = ammma.func_233815_a_(Attributes.field_233823_f_, 12.0);
            event.put(entity, ammma.func_233813_a_());
        }
    }
}

