/*
 * Decompiled with CFR 0.152.
 */
package cfrishausen.potionfoods;

import cfrishausen.potionfoods.PotionFoodItem;
import cfrishausen.potionfoods.data.Data;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.Potions;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"potionfoods");
    public static final List<Item> FOODS = Lists.newArrayList((Object[])new Item[]{Items.field_151034_e, Items.field_151009_A, Items.field_151025_P, Items.field_151147_al, Items.field_151157_am, Items.field_151153_ao, Items.field_196086_aW, Items.field_196087_aX, Items.field_196088_aY, Items.field_196089_aZ, Items.field_196102_ba, Items.field_196104_bb, Items.field_151106_aX, Items.field_151127_ba, Items.field_203180_bP, Items.field_151082_bd, Items.field_151083_be, Items.field_151076_bf, Items.field_151077_bg, Items.field_151078_bh, Items.field_151070_bp, Items.field_151172_bF, Items.field_151174_bG, Items.field_151168_bH, Items.field_151170_bI, Items.field_151158_bO, Items.field_179558_bo, Items.field_179559_bp, Items.field_179560_bq, Items.field_179561_bm, Items.field_179557_bn, Items.field_185164_cV, Items.field_185165_cW, Items.field_222112_pR, Items.field_226638_pX_, Items.field_151150_bK});
    public static final List<Potion> POTION_EFFECTS = Lists.newArrayList((Object[])new Potion[]{Potions.field_185234_f, Potions.field_185235_g, Potions.field_185236_h, Potions.field_185237_i, Potions.field_185238_j, Potions.field_185239_k, Potions.field_185240_l, Potions.field_185241_m, Potions.field_185242_n, Potions.field_185243_o, Potions.field_185244_p, Potions.field_185245_q, Potions.field_185246_r, Potions.field_185247_s, Potions.field_203185_t, Potions.field_203186_u, Potions.field_203187_v, Potions.field_203188_w, Potions.field_185248_t, Potions.field_185249_u, Potions.field_185250_v, Potions.field_185251_w, Potions.field_185252_x, Potions.field_185253_y, Potions.field_185254_z, Potions.field_185218_A, Potions.field_185219_B, Potions.field_185220_C, Potions.field_185221_D, Potions.field_185222_E, Potions.field_185223_F, Potions.field_185224_G, Potions.field_185225_H, Potions.field_185226_I, Potions.field_185227_J, Potions.field_222126_O, Potions.field_204841_O, Potions.field_204842_P});

    public static RegistryObject<PotionFoodItem> createFood(String name, int nutritionValue, float saturationValue, Supplier<EffectInstance> effect, Potion potion) {
        return ITEMS.register(name, () -> new PotionFoodItem(new Item.Properties().func_221540_a(new Food.Builder().func_221456_a(nutritionValue).func_221454_a(saturationValue).effect(effect, 1.0f).func_221453_d()).func_200916_a(ItemGroup.field_78039_h), potion));
    }

    public static RegistryObject<PotionFoodItem> createGoldenCarrot(String name, int nutritionValue, float saturationValue, Supplier<EffectInstance> effect, Potion potion) {
        return ITEMS.register(name, () -> new PotionFoodItem(new Item.Properties().func_221540_a(new Food.Builder().func_221456_a(nutritionValue).func_221454_a(saturationValue).effect(effect, 1.0f).func_221453_d()).func_200916_a(ItemGroup.field_78038_k), potion));
    }

    public static RegistryObject<PotionFoodItem> createGoldenApple(String name, int nutritionValue, float saturationValue, Supplier<EffectInstance> effect, Potion potion) {
        return ITEMS.register(name, () -> new PotionFoodItem(new Item.Properties().func_221540_a(new Food.Builder().func_221456_a(nutritionValue).func_221454_a(saturationValue).effect(effect, 1.0f).func_221452_a(new EffectInstance(Effects.field_76428_l, 100, 1), 1.0f).func_221452_a(new EffectInstance(Effects.field_76444_x, 2400, 0), 1.0f).func_221455_b().func_221453_d()).func_200916_a(ItemGroup.field_78039_h), potion));
    }

    public static RegistryObject<PotionFoodItem> createTurtleFood(String name, int nutritionValue, float saturationValue, Supplier<EffectInstance> effect, Supplier<EffectInstance> effect2, Potion potion) {
        return ITEMS.register(name, () -> new PotionFoodItem(new Item.Properties().func_221540_a(new Food.Builder().func_221456_a(nutritionValue).func_221454_a(saturationValue).effect(effect, 1.0f).effect(effect2, 1.0f).func_221453_d()).func_200916_a(ItemGroup.field_78039_h), potion));
    }

    public static RegistryObject<PotionFoodItem> createTurtleGoldenCarrot(String name, int nutritionValue, float saturationValue, Supplier<EffectInstance> effect, Supplier<EffectInstance> effect2, Potion potion) {
        return ITEMS.register(name, () -> new PotionFoodItem(new Item.Properties().func_221540_a(new Food.Builder().func_221456_a(nutritionValue).func_221454_a(saturationValue).effect(effect, 1.0f).effect(effect2, 1.0f).func_221453_d()).func_200916_a(ItemGroup.field_78038_k), potion));
    }

    public static RegistryObject<PotionFoodItem> createTurtleGoldenApple(String name, int nutritionValue, float saturationValue, Supplier<EffectInstance> effect, Supplier<EffectInstance> effect2, Potion potion) {
        return ITEMS.register(name, () -> new PotionFoodItem(new Item.Properties().func_221540_a(new Food.Builder().func_221456_a(nutritionValue).func_221454_a(saturationValue).effect(effect, 1.0f).effect(effect2, 1.0f).func_221452_a(new EffectInstance(Effects.field_76428_l, 100, 1), 1.0f).func_221452_a(new EffectInstance(Effects.field_76444_x, 2400, 0), 1.0f).func_221455_b().func_221453_d()).func_200916_a(ItemGroup.field_78039_h), potion));
    }

    public static RegistryObject<BlockItem> createCakeItem(String name, RegistryObject<Block> block) {
        return ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(ItemGroup.field_78039_h)));
    }

    public static void init() {
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        for (Item item : FOODS) {
            String foodName = item.getRegistryName().func_110623_a();
            Food food = item.func_219967_s();
            for (Potion potion : POTION_EFFECTS) {
                String potionName = potion.getRegistryName().func_110623_a();
                String itemName = potionName + "_" + foodName;
                Object effectInstanceSupplier = null;
                RegistryObject<PotionFoodItem> object = null;
                object = potion == Potions.field_203186_u || potion == Potions.field_203187_v || potion == Potions.field_203188_w ? (item == Items.field_151153_ao ? ModItems.createTurtleGoldenApple(itemName, food.func_221466_a(), food.func_221469_b(), () -> (EffectInstance)potion.func_185170_a().get(0), () -> (EffectInstance)potion.func_185170_a().get(1), potion) : (item == Items.field_151150_bK ? ModItems.createTurtleGoldenCarrot(itemName, food.func_221466_a(), food.func_221469_b(), () -> (EffectInstance)potion.func_185170_a().get(0), () -> (EffectInstance)potion.func_185170_a().get(1), potion) : ModItems.createTurtleFood(itemName, food.func_221466_a(), food.func_221469_b(), () -> (EffectInstance)potion.func_185170_a().get(0), () -> (EffectInstance)potion.func_185170_a().get(1), potion))) : (item == Items.field_151153_ao ? ModItems.createGoldenApple(itemName, food.func_221466_a(), food.func_221469_b(), () -> (EffectInstance)potion.func_185170_a().get(0), potion) : (item == Items.field_151150_bK ? ModItems.createGoldenCarrot(itemName, food.func_221466_a(), food.func_221469_b(), () -> (EffectInstance)potion.func_185170_a().get(0), potion) : ModItems.createFood(itemName, food.func_221466_a(), food.func_221469_b(), () -> (EffectInstance)potion.func_185170_a().get(0), potion)));
                Data.NEW_ITEMS.add(object);
                Data.BASE_FOODS.put(object, item);
                Data.BASE_FOOD_NAMES.put(object, foodName);
                Data.EFFECT_NAMES.put(object, potionName);
            }
        }
        for (RegistryObject registryObject : Data.NEW_CAKE_BLOCKS) {
            RegistryObject<BlockItem> cakeBlockItem = ModItems.createCakeItem(registryObject.getId().func_110623_a().replace("_block", "_item"), (RegistryObject<Block>)registryObject);
            Data.NEW_CAKE_BLOCK_ITEMS.add(cakeBlockItem);
        }
    }
}

